% Generated by roxygen2 (4.0.2): do not edit by hand
\name{integration_design_optim}
\alias{integration_design_optim}
\title{Function to build integration points (for the SUR criterion)}
\usage{
integration_design_optim(SURcontrol = NULL, d = NULL, lower, upper,
  model = NULL, min.prob = 0.001)
}
\arguments{
\item{SURcontrol}{Optional list specifying the procedure to build the integration points and weights.
Many options are possible; see 'Details'.}

\item{d}{The dimension of the input set. If not provided \code{d} is set equal to the length of \code{lower}.}

\item{lower}{Vector containing the lower bounds of the design space.}

\item{upper}{Vector containing the upper bounds of the design space.}

\item{model}{A list of kriging models of \code{km} class.}

\item{min.prob}{This argument applies only when importance sampling distributions are chosen.
For numerical reasons we give a minimum probability for a point to
belong to the importance sample. This avoids probabilities equal to zero and importance sampling
weights equal to infinity. In an importance sample of \code{M} points, the maximum weight becomes
\code{1/min.prob * 1/M}.}
}
\value{
A list with components:
\itemize{
\item{\code{integration.points}}{ \code{p x d} matrix of p points used for the numerical calculation of integrals}
\item{\code{integration.weights}}{ a vector of size \code{p} corresponding to the weight of each point. If all the points are equally
weighted, \code{integration.weights} is set to \code{NULL}}
}
}
\description{
Modification of the function  \code{\link[KrigInv]{integration_design}} from the package \code{\link[KrigInv]{KrigInv}} to
be usable for SUR-based optimization. Handles two or three objectives.
Available important sampling schemes: none so far
}
\details{
Options for the \code{SURcontrol} list are :
\itemize{
  \item A) If nothing is specified, \code{100 * d} points are chosen using the Sobol sequence;
  \item B) One can directly set the field \code{integration.points} (\code{p * d} matrix) for prespecified integration points.
       In this case these integration points and the corresponding vector \code{integration.weights} will be used
       for all the iterations of the algorithm;
  \item C) If the field \code{integration.points} is not set then the integration points are renewed at each iteration.
       In that case one can control the number of integration points \code{n.points} (default: \code{100*d}) and a specific
       distribution \code{distrib}. Possible values for distrib are: "\code{sobol}", "\code{MC}" and "\code{SUR}"
        (default: "\code{sobol}"):
        \itemize{
          \item C.1) The choice "\code{sobol}" corresponds to integration points chosen with the Sobol sequence in dimension \code{d} (uniform weight);
          \item C.2) The choice "\code{MC}" corresponds to points chosen randomly, uniformly on the domain;
          \item C.3) The choice "\code{SUR}" corresponds to importance sampling distributions (unequal weights). \cr
        When important sampling procedures are chosen, \code{n.points} points are chosen using importance sampling among a discrete
        set of \code{n.candidates} points (default: \code{n.points*10}) which are distributed according to a distribution \code{init.distrib}
        (default: "\code{sobol}"). Possible values for \code{init.distrib} are the space filling distributions "\code{sobol}" and "\code{MC}"
        or an user defined distribution "\code{spec}". The "\code{sobol}" and "\code{MC}" choices correspond to quasi random and random points
        in the domain. If the "\code{spec}" value is chosen the user must fill in manually the field \code{init.distrib.spec} to specify
        himself a \code{n.candidates * d} matrix of points in dimension \code{d}.
        }
}
}
\references{
V. Picheny (2014), Multiobjective optimization using Gaussian process emulators via stepwise uncertainty reduction,
\emph{Statistics and Computing}.
}
\seealso{
\code{\link[GPareto]{GParetoptim}} \code{\link[GPareto]{crit_SUR}} \code{\link[KrigInv]{integration_design}}
}

