% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_cerf_nngp.R
\name{estimate_cerf_nngp}
\alias{estimate_cerf_nngp}
\title{Estimate the Conditional Exposure Response Function using Nearest Neighbor Gaussian Process}
\usage{
estimate_cerf_nngp(data, w, GPS_m, params, kernel_fn, nthread = 1)
}
\arguments{
\item{data}{A data.table of observation data.
\itemize{
\item Column 1: Outcome (Y)
\item Column 2: Exposure or treatment (w)
\item Column 3~m: Confounders (C)
}}

\item{w}{A vector of exposure level to compute CERF.}

\item{GPS_m}{A data.table of GPS vectors.
\itemize{
\item Column 1: GPS
\item Column 2: Prediction of exposure for covariate of each data sample (e_gps_pred).
\item Column 3: Standard deviation of  e_gps (e_gps_std)
}}

\item{params}{A list of parameters that is required to run the process.
These parameters include:
\itemize{
\item alpha: A scaling factor for the GPS value.
\item beta: A scaling factor for the exposure value.
\item g_sigma: A scaling factor for kernel function (gamma/sigma).
\item tune_app: A tuning approach. Available approaches:
\itemize{
\item all: try all combinations of hyperparameters.
}
\item expand: Scaling factor to determine the total number of nearest neighbors.
The total is \code{2*expand*n.neighbour}.
\item n_neighbor: Number of nearest neighbors on one side.
\item block_size: Number of samples included in a computation block. Mainly
used to balance the speed and memory requirement. Larger \code{block_size}
is faster, but requires more memory.
alpha, beta, and g_sigma can be a vector of parameters.
}}

\item{kernel_fn}{A kernel function. A default value is a Gaussian Kernel.}

\item{nthread}{An integer value that represents the number of threads to be
used by internal packages.}
}
\value{
A cerf_nngp object that includes the following values:
\itemize{
\item w, the vector of exposure levels.
\item pst_mean, the computed mean for the w vector.
\item pst_sd, the computed credible interval for the w vector.
}
}
\description{
Estimates the conditional exposure response function (cerf) using
the nearest neighbor (nn) Gaussian Process (gp). The function tune the best
match (the lowest covariate balance) for the provided set of hyperparameters.
}
\examples{

\donttest{
set.seed(19)
sim.data <- generate_synthetic_data(sample_size = 120, gps_spec = 3)
# Estimate GPS function
GPS_m <- train_GPS(cov_mt = as.matrix(sim.data[,-(1:2)]),
                   w_all = as.matrix(sim.data$treat))
# exposure values
w.all <- seq(0,20,2)
data.table::setDT(sim.data)
cerf_nngp_obj <- estimate_cerf_nngp(sim.data,
                                    w.all,
                                    GPS_m,
                                    params = list(alpha = c(0.1),
                                                  beta = 0.2,
                                                  g_sigma = 1,
                                                  tune_app = "all",
                                                  n_neighbor = 20,
                                                  expand = 1,
                                                  block_size = 1e4),
                                    nthread = 1)
}

}
