% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportedOrganism.R
\name{visRDAGBP}
\alias{visRDAGBP}
\title{Species-specific biological process GO-DAG}
\usage{
visRDAGBP(organism, plot = TRUE)
}
\arguments{
\item{organism}{The organism supported by the package. Both the scientific / common name of the organism can be use
to derive the Sub-DAG. If this argument
is "BP" the reduced  BP GO-DAG is visualised.}

\item{plot}{If TRUE, both the reduced DAG and the GO-terms contained in each node are derived}
}
\value{
A list containing the plot of the DAG and all the GO terms presents in each node
}
\description{
A sub-dag of biological process terms for a certain species e.g DAG of the gene association GO-terms for
             Arabidopsis thaliana. The label "J","R" and "L" on the right side of the plot
             gives the number of connections between the regular node (RN) on the level and the
             nodes right below it (RN are nodes that have all their children nodes represented in the next level)
             .The supported organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat",
             "Mus musculus / Mouse", "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast",
             "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# Reduced GO-DAG for Human
visRDAGBP(organism = "Homo sapiens")

# Reduced GO-DAG for Rat
visRDAGBP(organism = "Rat")

# RN GO-terms on level 2 can be access as follows
visRDAGBP(organism = "Human", plot = FALSE)$"L2 RN"

# JN GO-terms on level 16 can be access as follows
visRDAGBP(organism = "Human", plot = FALSE)$"L16 JN"

# LN GO-terms on level 18 can be access as follows
visRDAGBP(organism = "Human", plot = FALSE)$"L18 LN"
}
