% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreeDistBP.R
\name{Level2LeafNodeBP}
\alias{Level2LeafNodeBP}
\title{GO biological process (BP) level leaf nodes getter}
\usage{
Level2LeafNodeBP(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{An organism of interest from the list of supported organism. If the parameter is NULL the results
are from the general GO-DAG (default).}
}
\value{
All leaf nodes on the level.
}
\description{
Derive all the leaf nodes from a GO BP level. The supported organism are "Homo sapiens / Human",
             "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm", "Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast", "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{

# level 2 leaf nodes for Drosophila melanogaster GO-DAG
Level2LeafNodeBP(2, "Drosophila melanogaster")

# level 10 leaf nodes for Drosophila melanogaster GO-DAG
Level2LeafNodeBP(10, "Drosophila melanogaster")

}
