% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ss.bin.df.r
\name{get.ss.bin.df}
\alias{get.ss.bin.df}
\title{Get single sample binary data.frame}
\usage{
get.ss.bin.df(
  a.trt = seq(0.5, 1, 0.5),
  b.trt = seq(0.5, 1, 0.5),
  beta.mean = seq(0.3, 0.7, 0.01),
  eff.ss = 1:40,
  x.trt = 0:80,
  n.trt = c(40:80),
  Delta.tv = 0.4,
  Delta.lrv = 0.3,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  rp = FALSE
)
}
\arguments{
\item{a.trt}{beta prior hyperparameter}

\item{b.trt}{beta prior hyperparameter}

\item{beta.mean}{mean of beta prior}

\item{eff.ss}{effective sample size of beta prior}

\item{x.trt}{sample responses}

\item{n.trt}{sample size}

\item{Delta.tv}{Base TPP}

\item{Delta.lrv}{Min TPP}

\item{tau.tv}{Base TPP threshold}

\item{tau.lrv}{Min TPP threshold}

\item{tau.ng}{No-Go threshold}

\item{rp}{logical for reparameterized beta}
}
\value{
returns a data.frame with GO/No-Go probabilities and decisions
}
\description{
Get Go/No-go/Continue result
}
\examples{
my.ss.bin.df <- get.ss.bin.df()
head(my.ss.bin.df)
}
