% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.combitwice.R
\name{predict.combitwice}
\alias{predict.combitwice}
\title{Predict GMDH Twice-Multilayered Combinatorial}
\usage{
\method{predict}{combitwice}(object, newdata, ...)
}
\arguments{
\item{object}{an object of class 'combitwice'}

\item{newdata}{matrix containing dependent variables in the model, wich the predictions are calculated.}

\item{...}{other undocumented arguments}
}
\value{
A matrix with predictions.
}
\description{
Calculates GMDH Twice-Multilayered Combinatorial model predictions for new data.
}
\examples{
set.seed(123)
x <- matrix(data = c(rnorm(1050)), ncol = 3, nrow = 350)
colnames(x) <- c("a", "b", "c")
y <- matrix(data = c(10 + x[, "a"] + x[, "b"]^2 + x[, "c"]^3), ncol = 1)
colnames(y) <- "y"
x.test <- x[1:10, ]
y.test <- y[1:10]
x <- x[-c(1:10), ]
y <- y[-c(1:10)]

mod <- gmdh.combi.twice(X = x, y = y, criteria = "PRESS")
pred <- predict(mod, x.test)
summary(sqrt((pred - y.test)^2))

}
