% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Accessory.R
\name{Theta.EAP}
\alias{Theta.EAP}
\title{Estimate thetas and their SEs (GUM, GGUM)}
\usage{
Theta.EAP(IP, SE = TRUE, precision = 4, N.nodes = 30)
}
\arguments{
\item{IP}{Object of class \code{GGUM}. The GUM/ GGUM estimated item parameters
via functions \code{GUM()}/ \code{GGUM()}, respectively.}

\item{SE}{Logical value: Estimate the standard errors of the theta estimates?
Default is \code{TRUE}.}

\item{precision}{Number of decimal places of the results (default = 4).}

\item{N.nodes}{Number of nodes for numerical integration (default = 30).}
}
\value{
If \code{SE = TRUE}, the function returns an \eqn{N\times 2}{Nx2} 
  matrix with two columns (thetas, SEs), where \eqn{N}{N} is the number of 
  rows in the data matrix (i.e., persons). If \code{SE = FALSE}, the function
  returns the theta estimates as a vector of length \eqn{N}{N}.
}
\description{
\code{Theta.EAP} estimates the person theta parameters via EAP.
}
\section{Details}{
 The EAP procedure used here is based on Roberts, Donoghue,
  and Laughlin (2000), namely Equation 25 for the \eqn{\theta}{theta}
  estimates and Equation 26 for corresponding standard errors. The EAP
  estimate is the posterior mean of the \eqn{\theta}{theta} distribution for
  the corresponding response pattern. The standard error is computed as an
  approximation to the standard deviation of the posterior distribution. See
  Roberts et al. (2000) for more details.
}

\examples{
# For GUM:
# Generate data
#   (toy example: Too few items (due to computation time constraints) for 
#   accurate estimation of person parameters; larger number of items is 
#   required in practice):
gen1 <- GenData.GGUM(400, 5, 3, "GUM", seed = 139)
# Fit the GUM:
fit1 <- GUM(gen1$data, 3)
# Estimate the theta parameters:
Theta.EAP(fit1)
\dontrun{
# For GGUM:
# Generate data:
set.seed(1); C <- sample(3:5, 10, replace = TRUE)
gen2 <- GenData.GGUM(2000, 10, C, "GGUM", seed = 156)
# Fit the GGUM:
fit2 <- GGUM(gen2$data, C)
# Estimate the theta parameters:
Theta.EAP(fit2)
}

}
\author{
Jorge N. Tendeiro, \email{tendeiro@hiroshima-u.ac.jp}
}
