% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sdist.GFGM.spline.R
\name{Sdist.GFGM.spline}
\alias{Sdist.GFGM.spline}
\title{Sub-distribution functions under the generalized FGM copula with the marginal distributions approximated by splines}
\usage{
Sdist.GFGM.spline(time, g1, g2, tmin, tmax, p, q, theta)
}
\arguments{
\item{time}{Vector of times.}

\item{g1}{Splines coefficients for the failure cause 1.}

\item{g2}{Splines coefficients for the failure cause 2.}

\item{tmin}{Lower bound of times.}

\item{tmax}{upper bound of times.}

\item{p}{Copula parameter that greater than or equal to 1.}

\item{q}{Copula parameter that greater than 1 (integer).}

\item{theta}{Copula parameter with restricted range.}
}
\value{
\item{time}{Failure times}
\item{Sdist.1}{Probability of an object fails due to the failure cause 1.}
\item{Sdist.2}{Probability of an object fails due to the failure cause 2.}
}
\description{
Sub-distribution functions under the generalized FGM copula with the marginal distributions approximated by splines.
}
\details{
The splines coefficients \code{g1} and \code{g2} are usually computed by \code{MLE.GFGM.spline}.
The copula parameter \code{q} is restricted to be a integer due to the binominal theorem.
The admissible range of \code{theta} is given in \code{Dependence.GFGM}.
}
\examples{
library(GFGM.copula)
Sdist.GFGM.spline(seq(1,5,1),rep(0.1,5),rep(0.1,5),1,5,3,2,0.75)
}
\references{
Shih J-H, Emura T (2016) Bivariate dependence measures and bivariate competing risks models under the generalized FGM copula, Statistical Papers, doi: 10.1007/s00362-016-0865-5.

Shih J-H, Emura T (2018) Likelihood-based inference for bivariate latent failure time models with competing risks udner the generalized FGM copula, Computational Statistics, doi: 10.1007/s00180-018-0804-0.
}
\seealso{
\code{\link{MLE.GFGM.spline}}, \code{\link{Dependence.GFGM}}
}
