% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qanova.R
\name{QANOVA}
\alias{QANOVA}
\title{QANOVA: Quantile-based analyis-of-variance}
\usage{
QANOVA(formula, data = NULL, quantiles = c(0.5), lin_mat = NULL,
  var_method = "interval", nperm = 1999, var_level = 0.95,
  nested.levels.unique = FALSE)
}
\arguments{
\item{formula}{A model \code{formula} object. The left hand side contains the response variable and the right
hand side contains the factor variables of interest. An interaction term must be
specified.}

\item{data}{A data.frame, list or environment containing the variables in formula
and the censoring status
indicator. Default option is \code{NULL}.}

\item{quantiles}{A vector of probabilties corresponding to the quantiles of interest.
By default is c(0.5), i.e. just the median is included.}

\item{lin_mat}{A matrix specifying which linear combination of the quantiles should be
included for the analysis. By default (\code{NULL}) the identity matrix is chosen, i.e.
all chosen quantiles are considered simulatenously.}

\item{var_method}{Method for the variance estimation of the sample quantiles. The default
("interval") is the interval-based estimator of Price and Bonett (2001). Additionally, the bootstrap
method ("boot") of Efron (1987) or a kernel density approach ("kernel") can be chosen.}

\item{nperm}{The number of permutations used for calculating the permuted p-value.
The default option is 1999.}

\item{var_level}{A number between 0 and 1 specifying the confidence level for the
interval variance estimation method; the default value is 0.95.}

\item{nested.levels.unique}{A logical specifying whether the levels of the nested
factor(s) are labeled uniquely or not.
 Default is FALSE, i.e., the levels of the nested factor are the same for each
 level of the main factor.}
}
\description{
The function \code{qanova} calculates the Wald-type statistic based on the
quantiles and/or their linear combinations, e.g. the interquartile range. Respective p-values
are obtained by a \eqn{\chi^2}-approximation and a permutation approach, respectively.
}
\details{
The \code{qanova} function calculates the Wald-type statistic based on quantiles
and linear combinations of them for general factorial designs. The procedure is fully
nonparametric and no specific assumption of the underlying distribution is required.
In particular, heteroscedastic settings can be studied. The analysis can be based on a single
quantile (e.g. the median, default choice), a linear combination of quantiles (e.g. the
interquartile range, set \code{quantiles=c(0.25,0.75)} and \code{lin_mat = matrix(c(-1,1),ncol=2)})
or on several (combinations of) quantiles simulatenously.

  The \code{qanova} function returns the test statistic as well as two
  corresponding p-values: the first is based on a \eqn{chi^2} approximation and
  the second one is based on a permutation procedure.

 @return A \code{qanova} object containing the following components:
 \itemize{
 \item{pvalues_stat}{The p-values obtained by \eqn{\chi^2}-approximation}
 \item{pvalues_per}{The p-values of the permutation approach}
 \item{statistics}{The value of the qanova along with degrees of freedom of the
 central chi-square distribution and p-value, as well as the p-value of the
  permutation procedure.}
 \item{nperm}{The number of permutations used for calculating the permuted p-value.}
}
}
\examples{
QANOVA(weightgain ~ source*type, data = HSAUR::weightgain,var_method = "interval", nperm =199)

}
\references{
Ditzhaus, M., Fried, R. and Pauly, M. (2021). QANOVA: Quantile-based Permutation Methods For General
Factorial Designs. TEST (to appear, ArXiv preprint arXiv:1912.09146).
Efron, B. (1979). Bootstrap methods: Another look at the jackknife. Ann. Statist., 7:1-26.
Price, R. and Bonett, D. (2001). Estimating the variance of the sample median. J. Stat. Comput.
Simul, 68:295-305.
}
\author{
Philipp Steinhauer
}
