% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GFA.R
\name{getDefaultOpts}
\alias{getDefaultOpts}
\title{A function for generating the default priors of GFA model}
\usage{
getDefaultOpts(bicluster = FALSE)
}
\arguments{
\item{bicluster}{Use binary sparsity priors in both the data modes? If FALSE
(default), the components will be dense in the data sources, but
group-sparse, i.e., each component is active in a (potentially
different) subset of the data sources. If TRUE, binary sparsity is
inferred for each data sample and feature, resulting in each component
to be interpretable as a multi-source bicluster.}
}
\value{
A list with the following model options:
\item{tauGrouped}{If TRUE (default), data views have separate noise
        precisions, otherwise each feature has.}
\item{normalLatents}{If TRUE, X will have a normal prior; if FALSE
 X, will have a spike-and-slab prior.}
\item{spikeW}{Sparsity prior of W. "group"=group sparsity, "element"=
 element-wise sparsity with shared hyperparameter across views, "shared"=
 element-wise sparsity with no grouping.}
\item{ARDW}{ARD prior type for W, determining the scale of the inferred
 components. "shared"=same scale for all the data sources, "grouped"
 (default)= separate scale for each data source, "element"=separate scale
 for each feature.}
\item{ARDLatent}{ARD prior type for X: "shared" (default)=shared scale for
  all the samples, "element"=separate scale for each sample.}
\item{imputation}{Missing value imputation type: "Bayesian" (default)=proper 
  Bayesian handling of missing values. "conservative"=missing values result
  in smaller parameter scale, which can be useful if tricky missing value
  structure causes exaggerated imputed values with the default setting
  (which can also be dealt with informative priors for alpha and beta).}
\item{iter.max}{The total number of Gibbs sampling steps (default 5000).}
\item{iter.saved}{The number of saved posterior samples (default 100).}
\item{iter.burnin}{The number of burn-in samples (default 2500).}
\item{init.tau}{The initial noise precision. High values imply initializing
  the model with an adequate number of components. Default 1000.}
\item{sampleZ}{When to start sampling spike and slab parameters (default:
 Gibbs sample 1).}
\item{prior.alpha_0t}{The shape parameter of tau's prior (default 10).}
\item{prior.beta_0t}{The rate parameter of tau's prior (default 10).}
\item{prior.alpha_0}{The shape parameter of alpha's prior (default 10).}
\item{prior.beta_0}{The rate parameter of alpha's prior (default 01).}
\item{prior.alpha_0X}{The shape parameter of beta's prior (default 10).}
\item{prior.beta_0X}{The rate parameter of beta's prior (default 1).}
\item{prior.beta}{Bernoulli prior for the spike-and-slab prior of W (counts
 for 1s and 0s; default c(1,1)).}
\item{prior.betaX}{Bernoulli prior for the possible spike-and-slab prior of
  X (default c(1,1)).}
\item{verbose}{The verbosity level. 0=no printing, 1=moderate printing,
 2=maximal printing (default 1).}
\item{convergenceCheck}{Check for the convergence of the data reconstruction,
 based on the Geweke diagnostic (default FALSE).}
\item{save.posterior}{A list determining which parameters' posterior samples are
  saved (default: X, W and tau).}
}
\description{
\code{getDefaultOpts} returns the priors of GFA
}
\details{
This function returns options defining the model's high-level structure
(sparsity priors) and the model's hyperparameters, defining uninformative
priors. We recommend keeping these as provided, with one exception: if the
uninformative prior of the noise residual (tau) seems to result in an overly
complex model (no components become shut down even if the initial K is set
high), risking overfitting, we recommend using
function \code{\link{informativeNoisePrior}} to adjust the priors.
}
\examples{
#Given pre-specified data collection Y and component number K
opts <- getDefaultOpts(bicluster=FALSE)
opts$normalLatents <- FALSE #Binary sparsity for each sample and data source
 \dontrun{model <- gfa(Y,opts,K)}
}
