% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_optimal_reference.R
\name{choose_optimal_reference}
\alias{choose_optimal_reference}
\title{Picks the most suitable Reference for systematic shift corrections}
\usage{
choose_optimal_reference(gc_peak_list = NULL, rt_col_name = NULL)
}
\arguments{
\item{gc_peak_list}{List of individual samples, where samples a data frames of numerical variables in columns. A column needs to contain retention times of peaks.}

\item{rt_col_name}{Name of the column in data frames of \code{gc_peak_list} that contains retention times.}
}
\value{
returns a list with following elements
\item{sample}{Name of the sample with the highest average similarity to all other samples}
\item{score}{Median number of shared peaks with other samples}
}
\description{
Selects the chromatogram that shows the highest average similarity to all other samples a the reference for linear corrections of systematic shifts in peak retention times.
}
\details{
In order to correct systematic errors in peak retention times the most suitable reference chromatogram is selected based on the objective criterion of the highest average similarity to all other chromatograms in the data. Precisely, the median number of shared peaks between a sample and all other samples is estimated for any chromatogram in \code{gc_peak_list}. The most suitable referene is then defined as the sample showing the highest median similarity score.
}
\author{
Martin Stoffel (martin.adam.stoffel@gmail.com) & Meinolf Ottensmann (meinolf.ottensmann@web.de)
}
\keyword{internal}

