% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCA_RDA_graphics.R
\name{PCA_RDA_graphics}
\alias{PCA_RDA_graphics}
\title{PCA_RDA_graphics function
This function facilitate the user creation of PCA (! from FactoMineR package !) enhanced graphics with multiple options.
Individuals and variables graphics are possible. With or without variable cor, cos, contrib.. correlation to dimensions.
RDA outputs are displayable as table under graphics.}
\usage{
PCA_RDA_graphics(
  complete.data.set,
  factor.names,
  sample.column,
  PCA.object,
  Dim.a,
  Dim.b,
  Barycenter,
  Segments,
  Barycenter.min.size,
  Ind.min.size,
  Segment.line.type,
  Segment.line.size,
  Ellipse.IC.95,
  Ellipse.Fac.1,
  Ellipse.Fac.2,
  Ellipse.Fac.3,
  factor.colors,
  factor.shapes,
  factor.sizes,
  Var.circle,
  Var.circle.size,
  Var.label.size,
  Overlaying.graphs,
  width.PCA.ind.graph,
  width.PCA.var.graph,
  width.heat.map.graph,
  Heat.map.graph,
  var.parameter.heat.map,
  Dims.heat.map,
  Display.cell.values.heat.map,
  Cluster.col.heat.map,
  Cluster.row.heat.map,
  RDA.object,
  RDA.table.graph,
  RDA.table.graph.height
)
}
\arguments{
\item{complete.data.set}{Original complete data set used for the PCA, with quantitative and qualitative/factor columns}

\item{factor.names}{Character vector of considered factor variables of PCA}

\item{sample.column}{Numeric or name (character) of the individual sample column. Default is data frame row names.}

\item{PCA.object}{The PCA object, built from package FactoMineR. PCA.object <- FactoMineR::PCA(mtcars_quant, scale.unit = T, ncp = 5, graph = F)}

\item{Dim.a}{Numeric value (1 ; 2 ...) of the first PCA dimension selected for graphic outputs.}

\item{Dim.b}{Numeric value (1 ; 2 ...) of the first PCA dimension selected for graphic outputs.}

\item{Barycenter}{TRUE or FALSE. TRUE : Calculate and Display the barycenter of individuals for Ellipse.Fac.1 and/or .2 and/or .3.}

\item{Segments}{TRUE or FALSE. TRUE : Display the linking segments between individuals and barycenters.}

\item{Barycenter.min.size}{Numeric. Minimum size of barycenter point projections. Ignore if Barycenter = FALSE}

\item{Ind.min.size}{Numeric. Minimum size of individuals point projections.}

\item{Segment.line.type}{Numeric. Type of segment lines (see ggplot2 line type). Ignore if Segments = FALSE}

\item{Segment.line.size}{Numeric. Minimum size of segment lines. Ignore if Segments = FALSE}

\item{Ellipse.IC.95}{TRUE or FALSE. TRUE : Calculate and Display the Ellipse (95\% mean confidence intervals) of individuals for Ellipse.Fac.1 and/or .2 and/or .3.}

\item{Ellipse.Fac.1}{Character. Name of 1st factor/data frame column for Barycenter / Ellipses calculation.}

\item{Ellipse.Fac.2}{Character. Name of 2nd factor/data frame column for Barycenter / Ellipses calculation.}

\item{Ellipse.Fac.3}{Character. Name of 3rd factor/data frame column for Barycenter / Ellipses calculation.}

\item{factor.colors}{Character. Name of the factor/column considered for individuals colors.}

\item{factor.shapes}{Character. Name of the factor/column considered for individuals shapes.}

\item{factor.sizes}{Character. Name of the factor/column considered for individuals colors.}

\item{Var.circle}{TRUE or FALSE. TRUE = Display the PCA variable circle projection.}

\item{Var.circle.size}{Numeric. Value for increasing the size of Var.circle graphic.}

\item{Var.label.size}{Numeric. Value for increasing the size of Var.circle graphic labels.}

\item{Overlaying.graphs}{TRUE or FALSE. TRUE = Overlaying of PCA individuals and variables graphics. Default is set to FALSE.}

\item{width.PCA.ind.graph}{Numeric. Width ratio for PCA individuals graphic.}

\item{width.PCA.var.graph}{Numeric. Width ratio for PCA variables graphic.}

\item{width.heat.map.graph}{Numeric. Width ratio for Heat map variables graphic.}

\item{Heat.map.graph}{TRUE or FALSE. TRUE = Display the heat map of variable X parameter correlation to dimension.}

\item{var.parameter.heat.map}{Character. Parameter selected for the heat map correlation of Variable parameter to dimensions. values : "cor", "cos2", "coor","contrib".}

\item{Dims.heat.map}{Numeric. Numeric vector c(1,2) of dimensions considered for the variable parameter correlation.}

\item{Display.cell.values.heat.map}{TRUE or FALSE. TRUE = Display the rounded value of correlations within heat map cells.}

\item{Cluster.col.heat.map}{TRUE or FALSE. TRUE = cluster heatmap columns / dimensions.}

\item{Cluster.row.heat.map}{TRUE or FALSE. TRUE = cluster heatmap rows / quantitative variables.}

\item{RDA.object}{The RDA object, built from package vegan. RDA.object <- vegan::rda(mtcars_quant, scale.unit = T, ncp = 5, graph = F)}

\item{RDA.table.graph}{TRUE or FALSE. TRUE = Display the RDA outputs table under PCA graphics.}

\item{RDA.table.graph.height}{Numeric. Set the ratio of RDA table graphic height. Defaut is set to 1.}
}
\value{
Several graphics
}
\description{
PCA_RDA_graphics function
This function facilitate the user creation of PCA (! from FactoMineR package !) enhanced graphics with multiple options.
Individuals and variables graphics are possible. With or without variable cor, cos, contrib.. correlation to dimensions.
RDA outputs are displayable as table under graphics.
}
\examples{

library(FactoMineR)
my.PCA <- FactoMineR::PCA(mtcars[,1:7], scale.unit = FALSE, ncp = 5, graph = FALSE)
PCA_RDA_graphics(complete.data.set = mtcars, factor.names = c("vs", "gear"), PCA.object = my.PCA)

}
