% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANFIS.R
\name{anfis.optimise}
\alias{anfis.optimise}
\title{ANFIS optimiser}
\usage{
anfis.optimise(
  anfis,
  data.trn,
  data.chk = NULL,
  epoch.total = 100,
  stepsize = 0.1,
  rate.inc = 1.1,
  rate.dec = 0.9,
  method = c("gradient", "lse"),
  err.log = F,
  online = 0,
  lambda = 1,
  opt.by = "err.opt",
  err.trn.fix = T
)
}
\arguments{
\item{anfis}{The given ANFIS model}

\item{data.trn}{The input and output data pairs as training data}

\item{data.chk}{The input and output data pairs as checking (validation) data}

\item{epoch.total}{The total training epochs.}

\item{stepsize}{The initial stepsize}

\item{rate.inc}{increasing rate of the stepsize}

\item{rate.dec}{decrasing rate of the stepsize}

\item{method}{The learning algorithms for Layer 1 and Layer 4 respectively. default method=c("gradient", "lse")}

\item{err.log}{T or F, the flag indicate whether to save the error log.}

\item{online}{0 -- batch; 1 -- online; 2 -- semi-online}

\item{lambda}{The forgetting rate for the LSE algorithm}

\item{opt.by}{To optimise the ANFIS model by: err.opt -- optimisation error; err.trn -- training error; err.chk -- checking (validation) error.}

\item{err.trn.fix}{T or F. When KM defuzzification is used for IT2 ANFIS, err.trn is not equal to err.opt. Hence, this flag is used for users to choose whether to fix this issue. The default value is set to T for the compatibility with previous built IT2 models. For T1 ANFIS, this flag can be set to F for speed improvement.}
}
\value{
The optimised ANFIS model.
}
\description{
To optimise the performance of a given ANFIS model by learning the parameters in L1 and L4.
}
\examples{
fis <- anfis.tipper()
anfis <- anfis.builder(fis)
data.num <- 5
input.num <- length(fis$input)
input.stack <- matrix(rnorm(data.num*input.num), ncol=input.num)
y <- matrix(rnorm(data.num))
data.trn <- cbind(input.stack, y)
anfis.eval(anfis, input.stack)
anfis.final <- anfis.optimise(anfis, data.trn, epoch.total=500,
                                 stepsize=0.01, rate.inc=1.1, rate.dec=0.9)
}
\references{
[1] C. Chen, R. John, J. Twycross, and J. M. Garibaldi, “An extended ANFIS architecture and its learning properties for type-1 and interval type-2 models,” in Proceedings IEEE International Conference on Fuzzy Systems, 2016, pp. 602–609. \cr
\doi{10.1109/FUZZ-IEEE.2016.7737742}

[2] C. Chen, R. John, J. Twycross, and J. M. Garibaldi, “Type-1 and interval type-2 ANFIS: a comparison,” in Proceedings IEEE International Conference on Fuzzy Systems, 2017, pp. 1–6.  \cr
\doi{10.1109/FUZZ-IEEE.2017.8015555}
}
\author{
Chao Chen
}
