% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fm_construct.R
\name{fm_construct}
\alias{fm_construct}
\title{Fuzzy monetary poverty estimation}
\usage{
fm_construct(
  predicate,
  weight,
  fm = "verma",
  ID = NULL,
  HCR,
  interval = c(1, 10),
  alpha = NULL,
  hh.size,
  k = 3,
  z1,
  z2,
  b,
  z,
  breakdown = NULL,
  verbose = TRUE
)
}
\arguments{
\item{predicate}{A numeric vector representing the poverty predicate (i.e. income or expenditure)}

\item{weight}{A numeric vector of sampling weights. if NULL simple random sampling weights will be used.}

\item{fm}{The memebership function (deafult is "verma". Other options are "ZBM", "belhadj", "chakravarty". See references below.)}

\item{ID}{A numeric or character vector of IDs. if NULL (the default) it is set as the row sequence.}

\item{HCR}{If fm="verma". The value of the head count ratio.}

\item{interval}{If fm="verma". A numeric vector of length two to look for the value of alpha (if not supplied).}

\item{alpha}{If fm="verma". The value of the exponent in equation $E(mu)^(alpha-1) = HCR$. If NULL it is calculated so that it equates the expectation of the membership function to HCR}

\item{hh.size}{If fm="ZBM". A numeric vector of household size.}

\item{k}{If fm="ZBM". The number of change points locations to estimate.}

\item{z1}{If fm="belhadj".}

\item{z2}{If fm="belhadj".}

\item{b}{If fm="belhadj". The shape parameter (if b=1 the mf is linear between z1 and z2)}

\item{z}{If fm="chakravarty".}

\item{breakdown}{A factor of sub-domains to calculate estimates for (using the same alpha).}

\item{verbose}{Logical. whether to print the proceeding of the procedure.}
}
\value{
If fm="verma". It returns a list containing the (fuzzy) membership function for each individual in the sample,
the estimated expected value of the function, the alpha parameter. if breakdown is supplied it gives an output for each level.
}
\description{
\code{fm_construct} constructs fuzzy monetary poverty estimates.
}
\details{
It implements the fuzzy set approach to monetary poverty measurement where
the usual dichotomy poor (1) not-poor(0) is replaced with a continuum score in $(0,1)$
}
\examples{
data(eusilc)
HCR <- .154
hh.size <- sample(1:4, 1000, replace = TRUE)
fm_construct(predicate = eusilc$red_eq, weight = eusilc$DB090,
fm = "verma", HCR = HCR, ID = eusilc$ID)
}
