#' Evaluate the angular position of a Fourier descriptor, as
#' generated by \code{\link{random.fourier.descriptor}}
#' at point t.
#' 
#' Returns the angular position of the Fourier descriptor.
#'
#' @include random-fourier-descriptor.R
#' @param fourier.descriptor A Fourier descriptor object generated by
#'   \code{\link{random.fourier.descriptor}}
#' @param steps At how many points along the curve should the descriptor
#'   be evaluated? This amounts to a resolution parameter. Defaults to 720.
#' @export
#' @examples
#' fourier.descriptor <- random.fourier.descriptor(12)
#'
#' theta <- cumbend(fourier.descriptor, 0)
#' @usage
#' fourier.descriptor <- random.fourier.descriptor(12)
#'
#' theta <- cumbend(fourier.descriptor, 0)

cumbend <- function(fourier.descriptor, t)
{
  theta <- -t
  
  for (frequency in 1:length(fourier.descriptor[['Amplitude']]))
  {
    amplitude <- fourier.descriptor[['Amplitude']][frequency]
    phase <- (fourier.descriptor[['Phase']][frequency] / 360) * 2 * pi
    theta <- theta + amplitude * cos(frequency * t - phase)
  }
  
  return(theta)
}
