% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forecast

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{Forecast}
\alias{Forecast}
\title{Forecast}
\description{An abstract class for storing the results of forecasting.  These classes do not contain any data directly, but instead contain a data object. Extend this class when you want to store the results of a model, and none of the convenience classes are applicable.}
\seealso{
Is inherited by : \code{\link{SimpleForecast}}, \code{\link{SimulatedForecast}}}
\examples{


SimpleForecast <- R6Class(
  classname = "SimpleForecast",
  inherit = Forecast,
  private = list(
    .data = MatrixData$new()
  ),
  public = list(
    binDist = function(cutoffs)\{
      stop("This doesn't really make sense.")
    \},
    mean = function()\{
      return(self$data)
    \},
    median = function()\{
      return(self$data)
    \},
    quantile = function(alphas)\{
      stop("This doesn't really make sense.")
    \},
    initialize = function(data,forecastTimes)\{
    	if(missing(data) && missing(forecastTimes))\{
    		return()
    	\}
      if(data$ncol != length(forecastTimes))\{
        stop("The number of columns should be the number of times forecasted.")
      \}
      private$.forecastMadeTime = now()
      private$.forecastTimes = forecastTimes
      private$.data = data
    \}
  ),
  active = list(
  )
)
}
\section{Fields}{
\describe{
\item{data}{ The data used to create the forecast.}
\item{forecastMadeTime}{When the forecast was created.}
\item{forecastTimes}{The times the forecast is about.}
\item{model}{The model used to create the forecast.}
}}
\section{Methods}{
\methodname{binDist(cutoffs)}{
This \bold{must} be extended.  Get the distribution of simulations of the data within fixed bins.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{cutoffs}{A numeric vector with elements to use as the dividing values for the bins.}
}}
\item{Value}{a FrameData.}
}}
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{initialize(...)}{
This function \bold{should} be extended. Create a new instance of this class.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{This function should take in any arguments just in case.}
}}}}
\methodname{mean()}{
This \bold{must} be extended.  This method extracts the elementwise mean of the forecast.  This function will not change the number of rows or columns in the data, but will convert probabilistic estimates into deterministic ones.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}
\item{Value}{a MatrixData.}
}}
\methodname{median()}{
This \bold{must} be extended.  This method extracts the elementwise median of the forecast.  This function will not change the number of rows or columns in the data, but will convert probabilistic estimates into deterministic ones.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}
\item{Value}{a MatrixData.}
}}
\methodname{quantile(alphas)}{
This \bold{must} be extended.  Get the cutoffs for each percentile in alphas.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{alphas}{A numeric vector with elements between \code{0} and \code{1} of percentiles to find cutoffs for.}
}}
\item{Value}{an ArrayData.}
}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
