% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.cpts.R
\name{screen.cpts}
\alias{screen.cpts}
\title{Change point time series plot}
\usage{
screen.cpts(metrics, type = "a", text = NULL)
}
\arguments{
\item{metrics}{output from \code{\link{metrics.all}}}

\item{type}{character indicating which type of metric to compile change points for.
Options are "h" for high flow metrics, "l" for low flow metrics, "b" for baseflow 
metrics, or "a" for all 30 metrics (10 high, 10 low, 10 baseflow).}

\item{text}{optional character string for margin text, e.g. for station name, 
location, or other notes. Set to NULL if no margin text is wanted, or set to "d" 
to use default text containing the station ID, station name, and province/state 
returned from \code{\link{station.info}}.}
}
\value{
When type="a", returns a data.frame of changepoint counts by metric 
  type and year.
}
\description{
Compiles change point information for all metrics and outputs a daily flow
time series plot overlain with a bar plot of changepoint counts by year.
}
\examples{
# load results from metrics.all function for the Caniapiscau River
data(caniapiscau.res)

# plot changepoints for all metrics
screen.cpts(caniapiscau.res, type="l")
}
\seealso{
\code{\link{metrics.all}}
}
\author{
Jennifer Dierauer
}
