% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.bf.stats.R
\name{pk.bf.stats}
\alias{pk.bf.stats}
\title{Calculate baseflow peak statistics}
\usage{
pk.bf.stats(TS, bfpct = c(25, 50, 75))
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{bfpct}{numeric vector of percentages used to define the 
start, middle, and end of the baseflow peak. Default is c(25, 50, 75)}
}
\value{
Returns a data.frame with the following columns:
  \itemize{
    \item Start - day of year defining the start of the baseflow peak
    \item Mid - day of year defining the middle of the baseflow peak
    \item End - day of year defining the end of the baseflow peak
    \item Dur - duration of the baseflow peak, in days
  }
}
\description{
This function finds the start, middle, end, and duration of the baseflow
peak based on percent of the total annual baseflow volume.
}
\details{
This function calculates metrics intended to focus on snowmelt-related
  streamflow occuring in spring and summer. For catchments in cold climates, 
  the baseflow peak can be interpreted as snowmelt-induced. Baseflow is estimated with 
  \code{\link{bf_eckhardt}}.
}
\examples{
data(cania.sub.ts)
res1 <- pk.bf.stats(cania.sub.ts)

# trend and changepoint plot for baseflow peak start doy
res2 <- screen.metric(res1[,1], "Day of Year")
}
\author{
Jennifer Dierauer
}

