% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NA.runs.r
\name{NA.runs}
\alias{NA.runs}
\title{Missing data runs for daily time series.}
\usage{
NA.runs(TS)
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}
}
\value{
Returns a data.frame with the following columns:
  \itemize{
    \item Start - Date of the start of the missing data period
    \item End - Date of the end of the missing data period
    \item Duration - number of days in the missing data period
  }
}
\description{
This function takes a data.frame from create.ts and returns a data.frame of 
missing data runs.
}
\examples{
data(caniapiscau)
cania.sub <- caniapiscau[300:1200,]
cania.ts <- create.ts(cania.sub)
res <- NA.runs(cania.ts)
}
\author{
Jennifer Dierauer
}
\seealso{
\code{\link{create.ts}} to create input, \code{\link{NA.sum}} to sum the
  the missing data occurrences by year or month.
}

