% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlexRecordLinkage.r
\name{createDataAlpha}
\alias{createDataAlpha}
\title{createDataAlpha}
\usage{
createDataAlpha(nCoefUnstable, stable)
}
\arguments{
\item{nCoefUnstable}{An integer value with the number of covariates (including the intercept): number of cov from A + number of cov from B + 1.}

\item{stable}{A boolean value indicating whether the Partially Identifying Variable (PIV) concerned is stable.}
}
\value{
An empty data frame (if stable=FALSE) with nCoefUnstable + 2 columns for book keeping of the elements necessary to update the parameter for instability. There are
nCoefUnstable + 2 of those elements: number of cov from A + number of cov from B + intercept + boolean vector indicating where the true values of the records (for the concerned PIV) are equal, vector of time gaps between records
}
\description{
createDataAlpha
}
\examples{
PIVs_config = list( V1 = list(stable = TRUE),
                    V2 = list(stable = TRUE),
                    V3 = list(stable = TRUE),
                    V4 = list(stable = TRUE),
                    V5 = list( stable = FALSE,
                               conditionalHazard = FALSE,
                               pSameH.cov.A = c(),
                               pSameH.cov.B = c()) )

PIVs_stable = sapply(PIVs_config, function(x) x$stable)

nCoefUnstable = c(0,0,0,0,1)

Valpha = mapply( createDataAlpha,
                 nCoefUnstable = nCoefUnstable,
                 stable = PIVs_stable,
                 SIMPLIFY=FALSE)
}
