% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm.data.R
\name{rm.data}
\alias{rm.data}
\title{Remove Poor Quality Data}
\usage{
rm.data(clean.data,
        chamber = c("CH1", "CH2", "CH3", "CH4",
                    "CH5", "CH6", "CH7", "CH8"),
        M.phase = "M0")
}
\arguments{
\item{clean.data}{a data frame obtained by using the function \code{\link{correct.meas}}}

\item{chamber}{string: the chamber where poor quality data were observed (must not contain multiple elements in a vector)}

\item{M.phase}{string: the measurement phase(s) which should be eliminated from further steps of the analysis.}
}
\value{
The function returns a data frame containing data of metabolic rate measurements corrected for background respiration, where values of the column 'O2.correct' for exluded measurement phases were nulled. The data frame is used in the functions \code{\link{extract.slope}} and \code{\link{QC.slope}}.
}
\description{
The function nulls values of the column 'O2.correct' for specified measurement phase(s) of a specified chamber in a data frame generated by the function \code{\link{correct.meas}}. As a result, those nulled data will not be available for futher steps of the analysis, particularly for the function \code{\link{extract.slope}}.
}
\examples{
# if the data have been already loaded to R,
# skip the first line of the code:
data(AMR.clean)
AMR.clean.modified <- rm.data(AMR.clean,
                              chamber = "CH3",
                              M.phase = c("M1","M2"))

}
