% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{sample_variogram}
\alias{sample_variogram}
\title{Sample variogram}
\usage{
sample_variogram(df, effect, min_np = 30)
}
\arguments{
\item{df}{A data frame containing the columns 'col', 'row', and the effect to be plotted.}

\item{effect}{The name of the effect to be plotted.}

\item{min_np}{Only semi variances based on at least \code{min_np} pairs of plots will be
displayed. By default, \code{min_np = 30}.}
}
\value{
Graphic of the sample variogram, where the x- and y-axes display the row and
  column displacements and the z-axis displays the semi-variance (variogram ordinates).
}
\description{
Creates a sample variogram. The x- and y-axes display the row and column displacements,
respectively. The z-axis displays the semi-variance (variogram ordinates).
}
\examples{
# Sample variogram of the simulated plot errors for trait 2 in environment 2 provided in the
# example data frame 'df_error_bivar'.

error_df <- df_error_bivar[df_error_bivar$env == 2, ]

vario <- sample_variogram(
  df = error_df,
  effect = "e.Trait.2",
)

# Sample variogram
vario

# Extraction of a data frame containing the column and row displacements as well as the
# semi-variances (sample variogram ordinates).

sample_df <- vario$data

}
