% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITRDB_FUNCTIONS.R
\name{read_crn_metadata}
\alias{read_crn_metadata}
\title{Read metadata from a Tucson-format chronology file.}
\usage{
read_crn_metadata(file, SCHWEINGRUBER)
}
\arguments{
\item{file}{A character string path pointing to a \code{*.crn} file to be read.}

\item{SCHWEINGRUBER}{Is the file in the Schweingruber-type Tucson format?}
}
\value{
A data.frame containing the metadata.
}
\description{
This function includes improvements to the \code{\link{read_crn}} function from the 
\pkg{dplR} library. The principle changes are better parsing of metadata, and support
for the Schweingruber-type Tucson format. Chronologies that are unable to be read
are reported to the user. The user (or \code{\link{read_crn}}) must tell the function whether
the file is a Schweingruber-type chronology.
}
\details{
Location information is converted to decimal degrees.
}

