% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FcircSEC.R
\name{transcriptExtract}
\alias{transcriptExtract}
\title{Extracting transcript information from the annotation file}
\usage{
transcriptExtract(annotationFile, databaseName, outputfile)
}
\arguments{
\item{annotationFile}{The annotation file (in gtf, gff or gff3 fromat) corresponding to the reference genome}

\item{databaseName}{The database name from where the annotation file was downloaded (the possible options are "ncbi", "ucsc" and "other")}

\item{outputfile}{The name of the output file}
}
\value{
The transcript information from the annotation file will be written in the output file 'outputfile'
}
\description{
This function extracts transcript information from the annotation file corresponding to reference genome
}
\examples{

#Loading an example annotation file and write to a file
#Here temporary directory is created as input-output
#directory. Please provide your own directory instead.
out_dir<-tempdir()
annotation_file<-data(refGenchr1)  
annotation_file<-refGenchr1
write.table(annotation_file, file.path(out_dir,"annotation_file.gtf"), 
         row.names=FALSE, sep="\\t",quote=FALSE, col.names=FALSE)

#Extraction of transcript information. Here, the output will be generated in file 
#transcriptdata.txt in out_dir directory
transcriptExtract(file.path(out_dir,"annotation_file.gtf"), "ucsc", 
    file.path(out_dir, "transcriptdata.txt"))

}
