% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FcircSEC.R
\name{get.fasta}
\alias{get.fasta}
\title{Generating sequences from the reference genome with specific intervals}
\usage{
get.fasta(ref_genome, circ_class_bed, out_filename)
}
\arguments{
\item{ref_genome}{The reference genome}

\item{circ_class_bed}{The bed file having chromosome, start and end position of each circRNAs (obtained from function \code{\link[FcircSEC]{circClassification}})}

\item{out_filename}{The name of the output file}
}
\value{
The fasta file of the sequences extracted from the reference genome for the given intervals will be written in the output file 'out_filename'
}
\description{
This function can extract the sequences from the reference genome for the given intervals (start, end) of chromosomes
}
\examples{

#Loading an example reference genome and write to a file
#Here temporary directory is created as input-output
#directory. Please provide you own directory instead.
out_dir<-tempdir()
ref_genom<-data("chr1")
ref_genom<-chr1
df.fasta=dataframe2fas(ref_genom, file.path(out_dir, "ref_genome.fasta"))

#Loading an example circRNA classification bed file and write to a file
circ_class_bed<-data("circRNA_classb")
circ_class_bed<-circRNA_classb
write.table(circ_class_bed, file.path(out_dir, "circ_class.bed"), 
    col.names=FALSE, row.names=FALSE)

#Getting genomic sequences of circRNAs. The output will be 
#generated in file circRNA_genomic_seq.fasta in out_dir directory
get.fasta(file.path(out_dir, "ref_genome.fasta"), 
   file.path(out_dir, "circ_class.bed"), 
   file.path(out_dir, "circRNA_genomic_seq.fasta"))

}
