% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{getlast}
\alias{getlast}
\alias{getlast.default}
\title{Get the Last Elements of a Vector or List}
\usage{
getlast(x, n = 1)

\method{getlast}{default}(x, n = 1)
}
\arguments{
\item{x}{A vector, list, or other supported data type.}

\item{n}{An integer specifying the number of elements to retrieve from the end. Default is 1.}
}
\value{
The last \code{n} elements of the input.
}
\description{
This function retrieves the last \code{n} elements of a vector or list.
}
\examples{
# Get the last element of a vector
getlast(c(1, 2, 3, 4, 5))
# Get the last 2 elements of a vector
getlast(c(1, 2, 3, 4, 5), 2)
# Get the last element of a list
getlast(list("a", "b", "c"))
# Get the last 2 elements of a list
getlast(list("a", "b", "c"), 2)
}
\keyword{indexing}
