% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixef.R
\name{fixef}
\alias{fixef}
\title{Estimated coefficients estimates for joint models}
\usage{
fixef(object, process = c("Longitudinal", "Event"), ...)
}
\arguments{
\item{object}{an object inheriting from class \code{jmcs}.}

\item{process}{for which sub-model to extract the estimated coefficients.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A numeric vector or a list of the estimated parameters for the fitted model.
}
\description{
Extracts the fixed effects for a fitted joint model.
}
\examples{
\donttest{
# a joint model fit
fit <- jmcs(ydata = ydata, cdata = cdata, 
long.formula = response ~ time + x1, 
surv.formula = Surv(surv, failure_type) ~ x1 + x2, 
random =  ~ time| ID)

# fixed effects for the longitudinal process
fixef(fit, process = "Longitudinal")
# fixed effects for the event process
fixef(fit, process = "Event")
}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
