% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarmTest.R
\name{farm.mean}
\alias{farm.mean}
\title{Tuning-free Huber mean estimation}
\usage{
farm.mean(X)
}
\arguments{
\item{X}{An \eqn{n}-dimensional data vector.}
}
\value{
A Huber mean estimator will be returned.
}
\description{
The function calculates adaptive Huber mean estimator from a data sample, with robustification parameter \eqn{\tau} determined by a tuning-free principle.
}
\examples{
set.seed(2019)
n = 1000
X = rlnorm(n, 0, 1.5) - exp(1.5^2 / 2)
mu = farm.mean(X)
}
\references{
Huber, P. J. (1964). Robust estimation of a location parameter. Ann. Math. Statist., 35, 73–101.

Wang, L., Zheng, C., Zhou, W. and Zhou, W.-X. (2018). A New Principle for Tuning-Free Huber Regression. Preprint.
}
\seealso{
\code{\link{farm.cov}} for tuning-free Huber-type covariance estimation.
}
