% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDch.R
\name{IDch}
\alias{IDch}
\title{IDs of children of ego}
\usage{
IDch(idego, d = NULL, keep_ego = FALSE)
}
\arguments{
\item{idego}{ID of ego(s)}

\item{d}{Name of database. If d is missing, the dataset dLH in the global environment (R workspace) is used. 
If no dLH in the global environment, the database dLH distributed with the Families package is used.}

\item{keep_ego}{Logical variable. If TRUE, a dataframe of parent-child and father-child dyads is produced. 
It includes, for each ego (parent), ego's ID and the IDs of ego's children.}
}
\value{
Two cases:
\itemize{
 \item keep_ego=FALSE: IDch() returns the IDs of children. If ego has no children or IDs of children are not
included in database (e.g. in case of last generation considered), the missing data symbol NA is returned. 
 \item keep_ego=TRUE: IDch() returns a data frame of parent-child dyads. It has the following columns: 
 \itemize{
   \item ID of parent of child (ego)
   \item ID of child
   \item sex of ego 
   \item sex of child
   }
}
}
\description{
Retrieves IDs of children of ego(s).
}
\examples{
# Load the data
data(dLH,package=("Families"))

IDch(idego=1)
set.seed(43)
id <- sample (dLH$ID[dLH$gen==1],10)
id2 <- IDch(idego=sort(id),keep_ego=TRUE)
id3 <- IDch(id2$idch,keep_ego=TRUE)


}
