% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequentialSelection.R
\name{sequentialBackwardSelection}
\alias{sequentialBackwardSelection}
\title{Sequential Backward Selection}
\usage{
sequentialBackwardSelection(stopCriterion = -1, stop = FALSE)
}
\arguments{
\item{stopCriterion}{Define a maximum number of iterations. Disabled if the value is -1 (default: -1 )}

\item{stop}{If true, the function stops if next iteration does not improve current results (default: FALSE)}
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on sequential backward selection. This function is called internally within the \code{\link{searchAlgorithm}} function. The SBS method \insertCite{MarillGreen1963}{FSinR} starts with all the features and removes a single feature at each step with a view to improving the evaluation of the set.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function with sbs
filter_evaluator <- filterEvaluator('determinationCoefficient')

# Generates the search function
sbs_search <- sequentialBackwardSelection()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
sbs_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Adan M. Rodriguez

Alfonso Jiménez-Vílchez

Francisco Aragón Royón
}
