% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{rcumsum}
\alias{pcumsum}
\alias{rcumsum}
\title{Computes the prior to or reverse cumulative sum of a vector.}
\usage{
rcumsum(x)

pcumsum(x)
}
\arguments{
\item{x}{a numeric object.}
}
\value{
A numeric vector that contains the prior-to or reverse cumulative sums.
}
\description{
Computes the prior-to (i.e., the cumulative sum prior to but not including the current value) or the reverse (i.e., the number that large or larger) cumulative sum of a vector.  Also works for 1-dimensional tables, matrices, and data.frames, though it is best used with vectors.
}
\note{
An \code{NA} in the vector causes all returned values at and after the first \code{NA} for \code{pcumsum} and at and before the last \code{NA} for \code{rcumsum} to be \code{NA}.  See the examples.
}
\examples{
## Simple example
cbind(vals=1:10,
      cum=cumsum(1:10),
      pcum=pcumsum(1:10),
      rcum=rcumsum(1:10))

## Example with NA
vals <- c(1,2,NA,3)
cbind(vals,
      cum=cumsum(vals),
      pcum=pcumsum(vals),
      rcum=rcumsum(vals))

## Example with NA
vals <- c(1,2,NA,3,NA,4)
cbind(vals,
      cum=cumsum(vals),
      pcum=pcumsum(vals),
      rcum=rcumsum(vals))

## Example with a matrix
mat <- matrix(c(1,2,3,4,5),nrow=1)
cumsum(mat)
pcumsum(mat)
rcumsum(mat)

## Example with a table (must be 1-d)
df <- sample(1:10,100,replace=TRUE)
tbl <- table(df)
cumsum(tbl)
pcumsum(tbl)
rcumsum(tbl)

## Example with a data.frame (must be 1-d)
df <- sample(1:10,100,replace=TRUE)
tbl <- as.data.frame(table(df))[,-1]
cumsum(tbl)
pcumsum(tbl)
rcumsum(tbl)
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\seealso{
\code{\link{cumsum}}.
}
\keyword{misc}

