% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FIT.R
\name{train.to.predict.adaptor}
\alias{train.to.predict.adaptor}
\title{Adapts the result of \code{train()} to an input to \code{predict()}.}
\usage{
train.to.predict.adaptor(models)
}
\arguments{
\item{models}{A collection of trained models as is returned by
\code{FIT::train()}.}
}
\value{
A collection of trained models in a form appropriate
  for the consumption by \code{FIT::predict()}.
}
\description{
At the moment \code{FIT::train()} returns a nested
list of trained models but \code{FIT::predict()} expects
to receive them as a flat list.
This ugly adaptor is provided 
in order to prepare for future changes in this implementation detail.
}
\examples{
\dontrun{
models <- FIT::train(..)
models2 <- train.to.predict.adaptor(models)
predictions <- FIT::predict(models2, ..)
}
}

