% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_options.R
\name{eval_options}
\alias{eval_options}
\title{List of population tables.}
\usage{
eval_options(
  Cur = FALSE,
  Endyr = NULL,
  Endyr.filter = NULL,
  All = FALSE,
  Type = "VOL",
  evalid = NULL,
  invyrs = NULL,
  measyrs = NULL,
  varCur = "INVYR",
  evalType = NULL,
  ...
)
}
\arguments{
\item{Cur}{Logical. If eval='FIA': extract plots with most current 
evaluation. If eval='custom': extract the most current sampled plots 
in the database.}

\item{Endyr}{Integer (YYYY). If eval='FIA', defines end year for
extracting one or more FIA evaluation. If eval='custom', defines 
end year for extracting the most current sampled plots until.}

\item{Endyr.filter}{Filter. If endyr != NULL, a filter to identify
when to use measEndyr, such as areas or plots identified as being 
disturbed in a particular year. In this example, plots sampled after
the disturbance will be excluded.}

\item{All}{Logical. If eval='FIA': includes all evaluations in 
database (annual inventory only). If eval='custom': includes all years 
in database (annual inventory only).}

\item{Type}{String vector. Evaluation types ('ALL','CURR','VOL','P2VEG',
DWM','INV','CHNG','GRM','REGEN'). If eval='FIA', Type is equivalent to
plots for FIA Evaluations where 'ALL' includes nonsampled plots; 'CURR' 
and 'VOL' include plots used for area or tree estimates, respectively; 
Type = 'GRM' includes plots used for growth, removals, mortality; and 
Type = 'CHNG' includes plots used for change estimates (See FIA database 
manual for regioin availability and/or differences 
(https://www.fia.fs.usda.gov/library/database-documentation/index.php) 
If eval='custom', the associated tables are extracted for each Type. 
Multiple Types are accepted.}

\item{evalid}{Integer. Only eval='FIA': extract data for a specific 
evaluation period. See notes for more information about FIA Evaluations.}

\item{invyrs}{Integer vector. eval='custom': defines specific
inventory years of data (e.g., 2010:2015). See FIA manual for 
definition of INVYR.}

\item{measyrs}{Integer vector. eval='custom': defines specific
measurement years of data (e.g., 2010:2015).}

\item{varCur}{String. Name of variable to use for most current plot
('MEASYEAR', 'INVYR').}

\item{evalType}{Deprecated. Use Type instead.}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for strata.
}
\description{
Returns a list of user-supplied parameters and parameter values for data 
evaluation (FIA or custom) extraction to be supplied to *DB functions.
}
\details{
If no parameters, an empty list is returned.
}
\examples{
eval_options(invyrs = 2015:2018)
}
\author{
Tracey S. Frescino
}
\keyword{list}
