% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spGetEstUnit.R
\name{spGetEstUnit}
\alias{spGetEstUnit}
\title{Spatial wrapper - Extracts point attribute values and area from a simple
feature or raster estimation unit layer.}
\usage{
spGetEstUnit(
  xyplt,
  xyplt_dsn = NULL,
  uniqueid = "PLT_CN",
  unittype = "POLY",
  unit_layer,
  unit_dsn = NULL,
  unitvar = NULL,
  unit.filter = NULL,
  areavar = NULL,
  areaunits = "acres",
  keepNA = FALSE,
  returnxy = FALSE,
  showext = FALSE,
  savedata = FALSE,
  exportsp = FALSE,
  exportNA = FALSE,
  spMakeSpatial_opts = NULL,
  savedata_opts = NULL,
  vars2keep = NULL,
  gui = FALSE
)
}
\arguments{
\item{xyplt}{Data frame, sf object, full pathname to *.csv or *shp, or layer
name in a geodatabase. Includes XY coordinates and unique identifier.  If
non-spatial, include options in spMakeSpatial_opts parameter.}

\item{xyplt_dsn}{String. Name of database where xyplt is. The dsn varies by
driver. See gdal OGR vector formats (https://www.gdal.org/ogr_formats.html).}

\item{uniqueid}{String.* Unique identifier of xyplt rows.}

\item{unittype}{String. Spatial layer type of unit_layer ("POLY", "RASTER").}

\item{unit_layer}{String or sf object. The name of the estimation unit
layer. The layer name may be a full pathname to a file, the
basename to a file, a spatial layer name from a database, or a
SpatialPolygons object with a defined projection.}

\item{unit_dsn}{String. The data source name (dsn; i.e., folder or database
name) of unit_layer. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional.}

\item{unitvar}{String. Name of estimation unit variable in unit_layer.}

\item{unit.filter}{String. Filter to subset unit_layer spatial layer.}

\item{areavar}{String. Name of area variable unit variable in unit_layer. If
NULL, calculates area by unitvar.}

\item{areaunits}{String. Output area units ("acres", "hectares",
"sqmeters").}

\item{keepNA}{Logical. If TRUE, returns data frame of NA values.}

\item{returnxy}{Logical. If TRUE, returns xy data as sf object (spxyplt).}

\item{showext}{Logical. If TRUE, layer extents are displayed in plot window.}

\item{savedata}{Logical. If TRUE, the input data with extracted values are
saved to outfolder.}

\item{exportsp}{Logical. If TRUE, the extracted strata point data are
exported to outfolder.}

\item{exportNA}{Logical. If TRUE, NA values are exported to outfolder.}

\item{spMakeSpatial_opts}{List. See help(spMakeSpatial_options()) for a list
of options. Use to convert X/Y values to simple feature (sf) coordinates.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{vars2keep}{String vector. Attributes in SAdoms, other than domvar to
include in dunitlut output and extract to pltassgn points.}

\item{gui}{Logical. If gui, user is prompted for parameters.}
}
\value{
\item{pltunit}{ Data frame. Input point data with extracted
estimation unit and strata values appended. } \item{sppltunit}{
SpatialPointsDataframe. Spatial point data with extracted estimation unit
values appended. } \item{unitarea}{ Data frame. Area by estimation unit. }
\item{unitvar}{ Data frame. Variable name for estimation unit in unitarea. }
\item{acrevar}{ Data frame. Variable name for area in unitarea. }
\item{pltassgnid}{ String. Unique identifier of plot. }

If savedata=TRUE, pltstrat and unitarea are saved to outfolder (Default
name: *_'date'.csv).  If exportshp=TRUE, the SpatialPointsDataFrame object
is exported to outfolder (Default name: datext_'date'.shp). Variable names
are truncated to 10 characters or less (See note below). Name changes are
output to 'outfn'_newnames_'data'.csv in outfolder.
}
\description{
Wrapper to get point attribute values and area from a simple feature or
raster layer of estimation units and calculates area. Points are reprojected
on-the-fly to projection of unit_layer using PROJ.4 transformation parameters
and sf spTransform function.  - Point attribute extraction from
simple feature (spExtractPoly) or from raster (spExtractRast) - Calculate
area by estimation unit(s) (areacalc.poly/areacalc.pixel)
}
\details{
*If variable = NULL, then it will prompt user for input.

If there is a raster and simple feature layer, and the projection of the
simple feature is different than the projection of the raster, the
simple feature object is transformed to the projection of raster (See note
about on-the-fly projection conversion).
}
\note{
If exportsp=TRUE:\cr If out_fmt="shp", the st_write (sf) function is
called. The ArcGIS driver truncates variable names to 10 characters or less.
Variable names are changed before export using an internal function
(trunc10shp). If Spatial object has more than 1 record, it will be returned
but not exported.

On-the-fly projection conversion\cr The spTransform (sf) method is used
for on-the-fly map projection conversion and datum transformation using
PROJ.4 arguments. Datum transformation only occurs if the +datum tag is
present in the both the from and to PROJ.4 strings. The +towgs84 tag is used
when no datum transformation is needed. PROJ.4 transformations assume NAD83
and WGS84 are identical unless other transformation parameters are
specified.  Be aware, providing inaccurate or incomplete CRS information may
lead to erroneous data shifts when reprojecting. See spTransform help
documentation for more details.

unitarea\cr Area by estimation unit is calculated and returned as object
named unitarea.  Area is based on the projection of unit_layer. If no
unit_layer input, than area is calculated from pixel counts.
}
\examples{
# Set up data from FIESTA
WYbhfn <- system.file("extdata",
                      "sp_data/WYbighorn_adminbnd.shp",
                      package = "FIESTA")
                      
# Create a `SpatialPoints` object from `WYplt`
WYspplt <- spMakeSpatialPoints(xyplt = WYplt, 
                               xy.uniqueid = "CN", 
                               xvar = "LON_PUBLIC", 
                               yvar = "LAT_PUBLIC", 
                               xy.crs = 4269)
                               
# Get estimation unit acres for Bighorn National Forest
spGetEstUnit(xyplt = WYplt, 
             uniqueid = "CN", 
             unit_layer = WYbhfn, 
             spMakeSpatial_opts = list(xvar = "LON_PUBLIC", 
                                       yvar = "LAT_PUBLIC", 
                                       prj = "longlat", 
                                       datum = "NAD83"))
}
\author{
Tracey S. Frescino, Chris Toney
}
\keyword{data}
