% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.fe.prov.R
\name{confint.fe.prov}
\alias{confint.fe.prov}
\title{Compute confidence intervals for fitted model}
\usage{
\method{confint}{fe.prov}(object, parm = "all", level = 0.95, data,
  Y.char, Z.char, prov.char, ...)
}
\arguments{
\item{object}{fitted model object (fit using \code{fe.prov})}

\item{parm}{parameter names. Since their are so many parameters, the default is
\code{"all"}, which is currently the only option available}

\item{level}{confidence level (default is \code{0.95})}

\item{data}{prepared \code{data.frame}. Use \code{\link{fe.data.prep}} to prepare the raw data}

\item{Y.char}{Y.char name of the response variable from \code{data} as a character string}

\item{Z.char}{Z.char names of covariates from \code{data} as vector of character strings}

\item{prov.char}{name of provider IDs variable as a character string}

\item{...}{extra arguments to be passed to confint}
}
\value{
Returns a \code{data.frame} of gamma and SRR lower and upper CI bounds. Each row is a
parameter, each column gives a different bound.
}
\description{
\code{confint.fe.prov} computes the (1-alpha)\% confidence intervals for the fixed
effect parameter estimates. Go to
\href{https://github.com/umich-biostatistics/FEprovideR}{Github} for a tutorial.
}
\examples{
# Name input variables and other parameters
# a small positive number specifying stopping
# criterion of Newton-Raphson algorithm
tol <- 1e-5
Y.char <- 'Y'
prov.char <- 'prov.ID'
Z.char <- paste0('z', 1:3)
data(hospital_prepared) # build in data set
fe.ls <- fe.prov(hospital_prepared, Y.char, Z.char, prov.char, tol) # model fitting

# confidence intervals
confint.fe.prov(fe.ls, parm = "all", level = 0.95,
                             hospital_prepared, Y.char, Z.char, prov.char)

}
\references{
He, K., Kalbfleisch, J.D., Li, Y. and Li, Y., 2013. Evaluating hospital
readmission rates in dialysis facilities; adjusting for hospital effects. Lifetime data
analysis, 19(4), pp.490-512.
}
\seealso{
\code{\link{fe.data.prep}},  \code{\link{fe.prov}},   \code{\link{test.fe.prov}},
\code{\link{funnel.SRR}}
}
