% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{match.pvals}
\alias{match.pvals}
\title{Matching Raw P-Values with Supports}
\usage{
match.pvals(test.results, pCDFlist, pCDFlist.indices = NULL)
}
\arguments{
\item{test.results}{either a numeric vector with p-values or an R6 object of class \code{\link[DiscreteTests]{DiscreteTestResults}} from package \code{\link[DiscreteTests:DiscreteTests-package]{DiscreteTests}} for which a discrete FDR procedure is to be performed.}

\item{pCDFlist}{list of the supports of the CDFs of the p-values; each list item must be a numeric vector, which is sorted in increasing order and whose last element equals 1.}

\item{pCDFlist.indices}{list of numeric vectors containing the test indices that indicate to which raw p-value each \strong{unique} support in \code{pCDFlist} belongs; ignored if the lengths of \code{test.results} and \code{pCDFlist} are equal.}
}
\value{
A vector where each raw p-value has been replaced by its nearest neighbor, if
necessary.
}
\description{
Constructs the observed p-values from the raw observed p-values, by rounding
them to their nearest neighbor matching with the supports of their
respective CDFs (as in function \code{p.discrete.adjust()} of package
\code{discreteMTP}, which is no longer available on CRAN).

\strong{Note}: This is an internal function and has to be called directly via
\code{:::}, i.e. \code{FDX:::match.pvals()}.
}
\details{
Well computed raw p-values should already belong to their respective CDF
support. So this function is called at the beginning of \code{\link[=discrete.GR]{discrete.GR()}},
\code{\link[=discrete.LR]{discrete.LR()}}, \code{\link[=discrete.PB]{discrete.PB()}} and their respective wrappers, just in
case raw p-values may be biased.

For each raw p-value that needs to be rounded, a warning is issued.
}
\examples{
\dontrun{
toyList <- list(c(0.3,0.7,1),c(0.1,0.65,1))
toyRaw1 <- c(0.3,0.65)
match.pvals(toyRaw1, toyList)
toyRaw2 <- c(0.31,0.6)
match.pvals(toyRaw2, toyList)
}

}
\seealso{
\code{\link[=discrete.GR]{discrete.GR()}}, \code{\link[=discrete.LR]{discrete.LR()}}, \code{\link[=discrete.PB]{discrete.PB()}}
}
\keyword{internal}
