% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommend_dv.R
\name{recommend_dv}
\alias{recommend_dv}
\title{Obtain recommendations for discriminant validity testing}
\usage{
recommend_dv(fits, index = "CFI", digits = 3)
}
\arguments{
\item{fits}{A list of simulated fit indices obtained from gen_fit. Based on the structure of fits, the number of models is derived.}

\item{index}{A vector of fit indices or measures provided by function fitmeasures in package lavaan. The default is set to CFI.}

\item{digits}{An optional integer to round fit values and cutoffs (min: 1, max: 5).}
}
\value{
A list of information regarding discriminant validity testing.
}
\description{
This function recommends on potential issues for discriminant validity testing, based on  differences between fit values and differences between flexible cutoffs. Two approaches of testing are supported: merging and constraining.
}
\examples{
\donttest{
#Note: Demonstration only! Please use higher numbers of replications for your applications (>= 500).
mod <- "
F1 =~ Q5 + Q7 + Q8
F2 =~ Q2 + Q4
F3 =~ Q10 + Q11 + Q12 + Q13 + Q18 + Q19 + Q20 + Q21 + Q22
F4 =~ Q1 + Q17
F5 =~ Q6 + Q14 + Q15 + Q16
"
#Two models for discriminant validity testing, this resembles constraining with a cutoff of .9
fits.dv.con <- gen_fit(
 mod1 = mod,
 x = bb1992,
 rep = 10,
 dv = TRUE,
 dv.factors = c("F4", "F5"),
 dv.cutoff = .9
)
recommend_dv(fits.dv.con)
#Two models for discriminant validity testing, this resembles merging.
fits.dv.merge <- gen_fit(
 mod1 = mod,
 x = bb1992,
 rep = 10,
 dv = TRUE,
 dv.factors = c("F4", "F5"),
 merge.mod = TRUE
)
recommend_dv(fits.dv.merge)
}
}
