#     This file is part of FAiR, a program to conduct Factor Analysis in R
#     Copyright 2008 Benjamin King Goodrich
#
#     FAiR is free software: you can redistribute it and/or modify
#     it under the terms of the GNU Affero General Public License as published by
#     the Free Software Foundation, either version 3 of the License, or
#     (at your option) any later version.
#
#     FAiR is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU Affero General Public License for more details.
#
#     You should have received a copy of the GNU Affero General Public License
#     along with FAiR.  If not, see <http://www.gnu.org/licenses/>.

.onLoad <- function(lib, pkg) {
	library.dynam("FAiR", pkg, lib)
}

.onUnload <- function(libpath) {
	library.dynam.unload("FAiR", libpath)
}

.onAttach <- function( ... ) {
FAiRLib <- dirname(system.file(package = "FAiR"))
version <- packageDescription("FAiR", lib.loc = FAiRLib)$Version
BuildDate <- packageDescription("FAiR", lib.loc = FAiRLib)$Date
cat(paste("\n##  FAiR Version", version, "Build Date:", BuildDate, "\n"))
cat("## See http://wiki.r-project.org/rwiki/doku.php?id=packages:cran:fair for more info")
cat("\nFAiR  Copyright (C) 2008  Benjamin King Goodrich\n")
cat("This program comes with ABSOLUTELY NO WARRANTY.\n")
cat("This is free software, and you are welcome to redistribute it\n")
cat("under certain conditions, namely those specified in the LICENSE file\n")
cat("in the root directory of the source code.\n")

if (length(grep("darwin", R.version$platform))) {
	cat("\n\nWARNING: It appears you are using a Mac.\n",
	"FAiR will CRASH under normal usage unless the X server is running.\n",
	"If you are using the R GUI, click the X icon in the top middle ",
	"region of the GUI and then restart the R GUI.\n",
	"If you are not using the R GUI, close R, execute 'open -a X11.app' in ",
	"a shell and then restart R\n",
	"If you do not have an X server installed, it is very difficult to use ",
	"FAiR on a Mac; see the OSX installation disc to install it if necessary.")
}

else if (.Platform$OS.type == "windows") {
	flush.console()
	cat("\n\n It appears you are using Windows.\n",
	    "It is recommended that you disable buffering by pressing Ctrl-W or\n",
	    "by deselecting Misc -> Buffered output in the menu at the top.\n",
	    "Doing so will consistently print the progress of the genetic algorithm.\n")
	flush.console()
}

## Initialize jit if installed
if(!require(jit)) {
	jit <<- function (f) return(NULL)
	warning("You can ignore the adjacent warning message about jit, although FAiR",
		" will run slightly faster if you install Ra and jit")
}

## Hack to run on R < 2.6.0 (maybe not necessary anymore)
if( (as.numeric(R.version$minor) < 6.0) | (as.numeric(R.version$minor) < 2) ) {
	warning("FAiR is not tested on this version of R but may work sufficiently.\n",
		"For best results, use R version 2.7.0 or later.\n")
}

invisible(NULL)
}

