% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fao.R
\name{read_fao}
\alias{read_fao}
\alias{getFAO}
\title{Access FAOSTAT API}
\usage{
read_fao(
  area_codes,
  element_codes,
  item_codes,
  year_codes,
  area_format = c("M49", "FAO", "ISO2", "ISO3"),
  item_format = c("CPC", "FAO"),
  dataset = "RL",
  metadata_cols = c("codes", "units", "flags", "notes"),
  clean_format = c("make.names", "unsanitised", "unsanitized", "snake_case"),
  include_na = FALSE,
  language = c("en", "fr", "es")
)

getFAO(
  area_codes,
  element_codes,
  item_codes,
  year_codes,
  area_format = c("M49", "FAO", "ISO2", "ISO3"),
  item_format = c("CPC", "FAO"),
  dataset = "RL",
  metadata_cols = c("codes", "units", "flags", "notes"),
  clean_format = c("make.names", "unsanitised", "unsanitized", "snake_case"),
  include_na = FALSE,
  language = c("en", "fr", "es")
)
}
\arguments{
\item{area_codes}{character. FAOSTAT area codes}

\item{element_codes}{character. FAOSTAT element codes}

\item{item_codes}{character. FAOSTAT item codes}

\item{year_codes}{character. Vector of desired years}

\item{area_format}{character. Desired area code type in output (input still
needs to use FAOSTAT codes)}

\item{item_format}{character. Item code}

\item{dataset}{character. FAO dataset desired, e.g. RL, FBS}

\item{metadata_cols}{character. Metadata columns to include in output}

\item{clean_format}{character/function. Whether to clean columns. Either one
of the formats described in [change_case] or a formatting function}

\item{include_na}{logical. Whether to include NAs for combinations of
dimensions with no data}

\item{language}{character. 2 letter language code for output labels}
}
\value{
data.frame in long format (wide not yet supported). Contains
  attributes for the URL and parameters used.
}
\description{
Uses the same functionality as the web interface to pull data from the
FAOSTAT API. Contains most of its parameters. Currently only works for
datasets that have area, item, element and year. Values for Chinese countries
are not yet deduplicated.
}
\examples{

\dontrun{

# Get data for Cropland (6620) Area (5110) in Antigua and Barbuda (8) in 2017
df = read_fao(area_codes = "8", element_codes = "5110", item_codes = "6620", 
year_codes = "2017")
# Load cropland area for a range of year
df = read_fao(area_codes = "106", element_codes = "5110", item_codes = "6620", 
year_codes = 2010:2020)

# Find which country codes are available
metadata_area <- read_dimension_metadata("RL", "area")
# Find which items are available
metadata_item <- read_dimension_metadata("RL", "item")
# Find which elements are available
metadata_element <- read_dimension_metadata("RL", "element")

}

}
