% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolicanalysis.R
\name{elongationAnalysis}
\alias{elongationAnalysis}
\title{Elongation analysis of fatty acids longer than 16 carbons.}
\usage{
elongationAnalysis(
  fadata,
  R2Thr = 0.98,
  maxiter = 10000,
  maxconvergence = 100,
  startpoints = 5,
  D2Thr = 0.1,
  parameters = FAMetA::parameters,
  verbose = TRUE
)
}
\arguments{
\item{fadata}{fadata containing synthesis results.}

\item{R2Thr}{positive numeric between 0 and 1 specifying the minimum R2
allowed for fits.}

\item{maxiter}{parameter passed to \link{nls.control}. Positive integer
specifying the maximum number of iterations allowed.}

\item{maxconvergence}{positive integer specifying the maximum number of
successes before choosing the winning model.}

\item{startpoints}{positive integer specifying the number of starting points
for each parameter to be estimated.}

\item{D2Thr}{minimum D2 value allowed to perform the elongation analysis.}

\item{parameters}{parameters to be estimated for each fatty acid. It can be
modified to change them or to add new fatty acids (adding new rows).}

\item{verbose}{print information messages.}
}
\value{
fadata list. Elongation analysis results will be saved at the 
elongation element of the fa list.
}
\description{
Elongation analysis of fatty acids longer than 16 carbons.
}
\details{
Main route of de novo synthesis plus elongation starts at 16 carbons
and then adds blocks of 2 carbons. Therefore, isotopologue distributions for
FA longer than 16 carbons will be modeled taking into account de novo
synthesis until FA(16:0), followed by single and independent elongation steps
(E1, E2 …, En). Parameters D0, D1 and D2 are imported from FA(16:0) or FA(14:0)
and thus, the only relevant parameters to be estimated in the elongation
analysis are Ei and I. For n6 and n3 series, elongation is expected from
FA(18:2)n6 and FA(18:3)n3 so that synthesis (S16:0) and first elongation step
(E1) are set to 0.
}
\examples{
\donttest{
ssdata <- dataCorrection(ssexamplefadata, blankgroup="Blank")
ssdata <- synthesisAnalysis(ssdata, R2Thr = 0.95, maxiter = 1e3,
maxconvergence = 100, startpoints = 5)
ssdata <- elongationAnalysis(ssdata, R2Thr = 0.95, maxiter = 1e4,
maxconvergence=100, startpoints = 5, D2Thr = 0.1)
}

\dontrun{
fadata <- dataCorrection(examplefadata, blankgroup = "Blank")
fadata <- synthesisAnalysis(fadata, R2Thr = 0.95, maxiter = 1e3,
maxconvergence = 100, startpoints = 5)
fadata <- elongationAnalysis(fadata, R2Thr = 0.95, maxiter = 1e4,
maxconvergence=100, startpoints = 5, D2Thr = 0.1)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
