% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{estimatePars}
\alias{estimatePars}
\title{Fit FA isotope distribution with non-linear regression using multiple
starting points to find the best fit.}
\usage{
estimatePars(
  formula,
  gridStart,
  datanls,
  maxiter,
  maxconvergence,
  limitPhi = 0.1
)
}
\arguments{
\item{formula}{formula.}

\item{gridStart}{starting points grid.}

\item{datanls}{data list.}

\item{maxiter}{parameter passed to \link{nls.control}. Positive integer
specifying the maximum number of iterations allowed.}

\item{maxconvergence}{positive integer specifying the maximum number of
successes before choosing the winning model.}

\item{limitPhi}{upper bound for overdispersion parameter.}
}
\value{
model.
}
\description{
Fit FA isotope distribution with non-linear regression using multiple
starting points to find the best fit.
}
\references{
Daniel Padfield and Granville Matheson (2020). nls.multstart: Robust Non-Linear Regression using AIC Scores. R package version 1.2.0. <https://CRAN.R-project.org/package=nls.multstart>
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
\keyword{internal}
