% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{readfadatafile}
\alias{readfadatafile}
\title{read FA data from a csv file.}
\usage{
readfadatafile(file, sep = ",", dec = ".")
}
\arguments{
\item{file}{csv file name.}

\item{sep}{column delimiter.}

\item{dec}{character used for decimal points.}
}
\value{
fadata.
}
\description{
First rows must contain metadata information such
as sample groups (row named sampletype) and any other extra information like
protein levels for external normalization. Then, the following row must
contain a Compound and Label columns followed by all sample names.
FA names must be unique and omega series must be indicated
(i.e. FA(20:4)n3, FA(24:1)n9, FA(16:0)). Unknown FA series can be named as nx,
ny, nz to differentiate between isomers. Labels must be specified with integer
numbers for 0 to maximum number of carbons.
}
\details{
read FA data from a csv file.
}
\examples{
\dontrun{
fadata <- readfadatafile("externafadata.csv", sep=",", dec=".")
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
