% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exactmed_c.R
\name{exactmed_c}
\alias{exactmed_c}
\title{Exact Mediation Effects Computation (Continuous Mediator)}
\usage{
exactmed_c(
  data,
  a,
  m,
  y,
  a1,
  a0,
  m_cov = NULL,
  y_cov = NULL,
  m_cov_cond = NULL,
  y_cov_cond = NULL,
  adjusted = TRUE,
  interaction = TRUE,
  Firth = FALSE,
  boot = FALSE,
  nboot = 1000,
  bootseed = 1991,
  confcoef = 0.95,
  hvalue_y = NULL,
  yprevalence = NULL,
  mf = NULL
)
}
\arguments{
\item{data}{A named data frame that includes the exposure, mediator and outcome variables as well as the covariates
to be adjusted for in the models. The exposure can be either binary or continuous. If a covariate is categorical,
it has to be included in the data frame as a factor, character or logical variable.}

\item{a}{The name of the binary or continuous exposure variable.}

\item{m}{The name of the continuous mediator variable.}

\item{y}{The name of the binary outcome variable.}

\item{a1}{A value corresponding to the high level of the exposure.}

\item{a0}{A value corresponding to the low level of the exposure.}

\item{m_cov}{A vector containing the names of the adjustment variables (covariates) in the mediator model.}

\item{y_cov}{A vector containing the names of the adjustment variables (covariates) in the outcome model.}

\item{m_cov_cond}{A named vector (atomic vector or list) containing specific values for some or all
of the adjustment covariates \code{m_cov} in the mediator model. Please consult the package vignette for details.}

\item{y_cov_cond}{A named vector (atomic vector or list) containing specific values for some or all
of the adjustment covariates \code{y_cov} in the outcome model. Please consult the package vignette for details.}

\item{adjusted}{A logical variable specifying whether to obtain adjusted or unadjusted estimates.
If \code{adjusted = FALSE}, vectors \code{m_cov} and \code{y_cov} are ignored by the procedure.}

\item{interaction}{A logical variable specifying whether there is an exposure-mediator interaction term in the outcome model.}

\item{Firth}{A logical variable specifying whether to compute conventional or penalized maximum likelihood estimates
for the outcome logistic regression model.}

\item{boot}{A logical value specifying whether the confidence intervals are obtained
by the delta method or by percentile bootstrap.}

\item{nboot}{The number of bootstrap replications used to obtain the confidence intervals if \code{boot = TRUE}.}

\item{bootseed}{The value of the initial seed (positive integer) for random number generation if \code{boot = TRUE}.}

\item{confcoef}{A number between 0 and 1 for the confidence coefficient (ex.: 0.95) of the interval estimates.}

\item{hvalue_y}{The value corresponding to the high level of the outcome. If the outcome is already coded
as a numerical binary variable taking 0 or 1 values, then by default \code{hvalue_y = 1}.}

\item{yprevalence}{The prevalence of the outcome in the population. Option used when case-control data are used.
The low level of the outcome is treated as the control level.}

\item{mf}{The value of the mediator at which the conditional controlled direct effect is computed. If it is not specified,
\code{mf} is fixed at the sample-specific mean of the mediator (default).}
}
\value{
An object of class \code{results_c} is returned:
\item{ne.or}{Natural effects estimates on OR scale.}
\item{ne.rr}{Natural effects estimates on RR scale.}
\item{ne.rd}{Natural effects estimates on RD scale.}
\item{cde}{Controlled direct effect estimates.}
\item{med.reg}{Summary of the mediator regression.}
\item{out.reg}{Summary of the outcome regression.}

If \code{boot==TRUE}, the returned object also contains:
\item{boot.ne.or}{Bootstrap replications of natural effects on OR scale.}
\item{boot.ne.rr}{Bootstrap replications of natural effects on RR scale.}
\item{boot.ne.rd}{Bootstrap replications of natural effects on RD scale.}
\item{boot.cde.or}{Bootstrap replications of controlled direct effect on OR scale.}
\item{boot.cde.rr}{Bootstrap replications of controlled direct effect on RR scale.}
\item{boot.cde.rd}{Bootstrap replications of controlled direct effect on RD scale.}
\item{boot.ind}{Indices of the observations sampled in each bootstrap replication (one replication per column).}
}
\description{
Relying on a regression-based approach, the \code{exactmed_c()} function calculates standard
    causal mediation effects when the outcome is binary and the mediator is continuous. More precisely, \code{exactmed_c()}
    relies on logistic and linear models for the outcome and mediator, respectively, in order to compute \emph{exact}
    conditional natural direct and indirect effects.
    Nested counterfactual probabilities underlying the definition of natural effects are calculated using numerical integration.
    The function returns point and interval estimates for the conditional natural effects without making any assumption
    regarding the rareness or commonness of the outcome (hence the term exact). For completeness, \code{exactmed_c()} also
    calculates the conditional controlled direct effect at a specified value of the mediator. Natural and controlled effects
    estimates are reported using three different scales: odds ratio (OR), risk ratio (RR) and risk difference (RD).
    The interval estimates can be obtained either by the delta method or the bootstrap.
}
\details{
By default, \code{exactmed_c()} reports mediation effects evaluated at the sample-specific mean values of the numerical covariates
    (including the dummy variables created internally by the function to represent the non-reference levels of the categorical covariates).
    In order to estimate mediation effects at specific values of some covariates (that is, stratum-specific effects),
    the user needs to provide named vectors \code{m_cov_cond} and/or \code{y_cov_cond} containing those values or levels. The adjustment
    covariates appearing in both \code{m_cov} and \code{y_cov} (common adjustment covariates) must have the same values; otherwise,
    \code{exactmed_c()}'s execution is aborted and an error message is displayed in the R console.

    The Firth parameter allows to reduce the bias of the outcome logistic regression coefficients estimators when facing a problem of
    separation or quasi-separation. The bias reduction is achieved by the \code{\link[brglm2]{brglmFit}} fitting method of the \emph{brglm2} package.
    More precisely, estimates are obtained using a penalized maximum likelihood with a Jeffreys prior penalty, which is equivalent to the mean
    bias-reducing adjusted score equation approach in Firth (1993).

    When the data come from a case-control study, the \code{yprevalence} parameter should be used and its value ideally correspond to the true outcome prevalence.
    \code{exactmed()} accounts for the ascertainment in the sample by employing weighted regression techniques that use inverse probability weighting (IPW)
    with robust standard errors. These errors are obtained via the \code{\link[sandwich]{vcovHC}} function of the R package \emph{sandwich}.
    Specifically, we use the HC3 type covariance matrix estimator (default type of the \code{\link[sandwich]{vcovHC}} function).
}
\note{
The \code{exactmed_c()} function only works for complete data. Users can apply multiple imputation techniques (e.g., R package \emph{mice})
 or remove observations of variables used in mediation analysis that have missing values (NA).
}
\examples{
exactmed_c(
  data = datamed_c, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2")
)

exactmed_c(
  data = datamed_c, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2"), yprevalence = 0.1
)

m_cov_cond <- c(C1 = 0.1, C2 = 0.4)
y_cov_cond <- c(C1 = 0.1, C2 = 0.4)

exactmed_c(
  data = datamed_c, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2"),
  m_cov_cond = m_cov_cond, y_cov_cond = y_cov_cond
)

C1b <- factor(sample(c("a", "b", "c"), nrow(datamed_c), replace = TRUE))
datamed_c$C1 <- C1b

m_cov_cond <- list(C1 = "c", C2 = 0.4)
y_cov_cond <- list(C1 = "c", C2 = 0.4)

exactmed_c(
  data = datamed_c, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2"),
  m_cov_cond = m_cov_cond, y_cov_cond = y_cov_cond
)
}
\references{
Samoilenko M, Blais L, Lefebvre G. Comparing logistic and log-binomial models for causal mediation analyses of
binary mediators and rare binary outcomes: evidence to support cross-checking of mediation results in practice.
\emph{Observational Studies}.2018;4(1):193-216.

Samoilenko M, Lefebvre G. Parametric-regression-based causal mediation analysis of binary outcomes and binary mediators:
moving beyond the rareness or commonness of the outcome, \emph{American Journal of Epidemiology}.2021;190(9):1846-1858. \doi{10.1093/aje/kwab055}.

Samoilenko M, Lefebvre G. An exact regression-based approach for the estimation of the natural direct and indirect effects
with a binary outcome and a continuous mediator. \emph{Statistics in Medicine}.2022;1-35. \doi{10.1002/sim.9621}.

Firth D. Bias reduction of maximum likelihood estimates.
\emph{Biometrika}.1993;80:27-38. \doi{10.2307/2336755}.
}
