\name{coreCA}
\alias{coreCA}
\encoding{UTF-8}
\title{
coreCA
}
\description{
coreCA performs the core of correspondence analysis (CA), multiple correspondence analysis (MCA) and related techniques.
}
\usage{
coreCA(DATA, masses = NULL, weights = NULL, hellinger = FALSE, symmetric = TRUE, k = 0)
}
\arguments{
  \item{DATA}{original data to decompose and analyze via the singular value decomposition.}
  \item{masses}{a vector or diagonal matrix with masses for the rows (observations). If NULL, one is created or the plain SVD is used.}
  \item{weights}{a vector or diagonal matrix with weights for the columns (measures). If NULL, one is created or the plain SVD is used.}
  \item{hellinger}{a boolean. If FALSE (default), Chi-square distance will be used. If TRUE, Hellinger distance will be used.}
  \item{symmetric}{a boolean. If TRUE (default) symmetric factor scores for rows and columns are computed. If FALSE, the simplex (column-based) will be returned.}
  \item{k}{number of components to return (this is not a rotation, just an \emph{a priori} selection of how much data should be returned).}  
}
\details{
This function should not be used directly. Please use \code{\link{epCA}} or \code{\link{epMCA}} unless you plan on writing extensions to ExPosition. Any extensions wherein CA is the primary analysis should use \code{coreCA}.
}
\value{
Returns a large list of items which are also returned in \code{\link{epCA}} and \code{\link{epMCA}} (the help files for those functions will refer to this as well).\cr
All items with a letter followed by an \emph{i} are for the \emph{I} rows of a DATA matrix. All items with a letter followed by an \emph{j} are for the \emph{J} rows of a DATA matrix.\cr\cr
\item{fi}{factor scores for the row items.}
\item{di}{square distances of the row items.}
\item{ci}{contributions (to the variance) of the row items.}
\item{ri}{cosines of the row items.}
\item{fj}{factor scores for the column items.}
\item{dj}{square distances of the column items.}
\item{cj}{contributions (to the variance) of the column items.}
\item{rj}{cosines of the column items.}
\item{t}{the percent of explained variance per component (tau).}
\item{eigs}{the eigenvalues from the decomposition.}
\item{pdq}{the set of left singular vectors (pdq$p) for the rows, singular values (pdq$Dv and pdq$Dd), and the set of right singular vectors (pdq$q) for the columns.}
\item{M}{a column-vector or diagonal matrix of masses (for the rows)}
\item{W}{a column-vector or diagonal matrix of weights (for the columns)}
\item{X}{the final matrix that was decomposed (includes scaling, centering, masses, etc...).}
\item{hellinger}{a boolean. TRUE if Hellinger distance was used.}
}
\references{
Abdi, H., and Williams, L.J. (2010). Principal component analysis. \emph{Wiley Interdisciplinary Reviews: Computational Statistics}, 2, 433-459.\cr
Abdi, H., and Williams, L.J. (2010). Correspondence analysis. In N.J. Salkind, D.M., Dougherty, & B. Frey (Eds.): \emph{Encyclopedia of Research Design}. Thousand Oaks (CA): Sage. pp. 267-278.\cr
Abdi, H. (2007). Singular Value Decomposition (SVD) and Generalized Singular Value Decomposition (GSVD). In N.J. Salkind (Ed.): \emph{Encyclopedia of Measurement and Statistics}.Thousand Oaks (CA): Sage. pp. 907-912.
Greenacre, M. J. (2007). Correspondence Analysis in Practice. \emph{Chapman and Hall}.
}
\author{
Derek Beaton and Hervé Abdi.
}
\seealso{
	\code{\link{epCA}}, \code{\link{epMCA}}
}
\keyword{ misc }
\keyword{ multivariate }
