% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phaseDiagram4S.R
\name{phaseDiagram4S}
\alias{phaseDiagram4S}
\title{Phase Diagram for two-player games with four strategies}
\usage{
phaseDiagram4S(
  A,
  dynamic,
  params = NULL,
  trajectory = NULL,
  strategies = c("1", "2", "3", "4"),
  noRGL = TRUE
)
}
\arguments{
\item{A}{Numeric matrix of size 4x4 representing the number of strategies of
a symmetric matrix game.}

\item{dynamic}{Function representing an evolutionary dynamic.}

\item{params}{Numeric vector with additional parameters for the evolutionary
dynamic.}

\item{trajectory}{Numeric vector of size 4 representing the initial value
for the trajectory to be examined.}

\item{strategies}{String vector of length 4 that names all strategies.}

\item{noRGL}{Logical value that handles diagram rotation. If
set to \code{FALSE}, diagram will be rotatable, otherwise not. Default
is \code{TRUE}.}
}
\value{
None.
}
\description{
Plots phase diagram of a game with two players and four
 strategies.
}
\examples{
A <- matrix(c(5, -9, 6, 8, 20, 1, 2, -18, -14, 0, 2, 20, 13, 0, 4, -13),
 4, 4, byrow=TRUE)
state <- c(0.3, 0.2, 0.1, 0.4)
phaseDiagram4S(A, Replicator, NULL, state)
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
