% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signtest.evaluate.core.R
\name{signtest.evaluate.core}
\alias{signtest.evaluate.core}
\title{Sign Test}
\usage{
signtest.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A data frame with the following components. \item{Comparison}{The
  comparison measure.} \item{ChiSq}{The test statistic (\mjseqn{\chi^{2}}).}
  \item{p.value}{The p value for the test statistic.} \item{significance}{The
  significance of the test statistic (*: p \mjseqn{\leq} 0.01; **: p
  \mjseqn{\leq} 0.05; ns: p \mjseqn{ > } 0.05).}
}
\description{
Test difference between means and variances of entire collection (EC) and
core set (CS) for quantitative traits by Sign test (\mjseqn{+} versus
\mjseqn{-})
\insertCite{basigalup_development_1995,tai_core_2001}{EvaluateCore}.
\loadmathjax
}
\details{
The test statistic for Sign test (\mjseqn{\chi^{2}}) is computed as follows.

\mjsdeqn{\chi^{2} = \frac{(N_{1}-N_{2})^{2}}{N_{1}+N_{2}}}

Where, where \mjseqn{N_{1}} is the number of variables for which the mean or
variance of the CS is greater than the mean or variance of the EC (number of
\mjseqn{+} signs); \mjseqn{N_{2}} is the number of variables for which the
mean or variance of the CS is less than the mean or variance of the EC
(number of \mjseqn{-} signs). The value of \mjseqn{\chi^{2}} is compared with
a Chi-square distribution with 1 degree of freedom.
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

signtest.evaluate.core(data = ec, names = "genotypes",
                       quantitative = quant, selected = core)


}
\references{
\insertAllCited{}
}
