% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Stocks_List.R
\name{EN_Stocks_List}
\alias{EN_Stocks_List}
\title{Euronext Stocks List}
\usage{
EN_Stocks_List(stock_choice)
}
\arguments{
\item{stock_choice}{A character string specifying the stock exchange. Options include "A" or "Amsterdam," "B" or "Brussels," "D" or "Dublin", "L" or "Lisbon," "M" or "Milan," "P" or "Paris," and "O" or "Oslo."}
}
\value{
A data frame containing information about companies listed on the specified stock exchange.
If the stock exchange choice is invalid, the function returns an error message.
}
\description{
This function retrieves a list of companies listed on the Euronext stock exchanges,
filtered by the initial letter of their names. It provides information such as the
company name, ticker symbol, ISIN code, market, last closing price, percentage change,
and a link to the company's details on the Euronext website.
}
\examples{
\donttest{
# Example usage:
a_result_df <- EN_Stocks_List("A") # For Amsterdam Stock
head(a_result_df[, c(1:5)])

b_result_df <- EN_Stocks_List("B") # For Brussels Stock
p_result_df <- EN_Stocks_List("P") # For Paris Stock
l_result_df <- EN_Stocks_List("L") # For Lisbon Stock
m_result_df <- EN_Stocks_List("M") # For Milan Stock
d_result_df <- EN_Stocks_List("D") # For Dublin Stock
o_result_df <- EN_Stocks_List("O") # For Oslo Stock
}


}
\seealso{
\code{\link{EN_Ticker_Performance}}

Other Infos Retrieval: 
\code{\link{EN_Bonds_List_bis}()},
\code{\link{EN_Bonds_List}()},
\code{\link{EN_Etfs_List_bis}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()},
\code{\link{EN_GetISIN_F}()},
\code{\link{EN_Get_News}()},
\code{\link{EN_Indices_List}()},
\code{\link{En_Market.Sumarry}()}
}
\concept{Companies List by stock}
\concept{Infos Retrieval}
