% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_HistData.R
\name{EN_HistData}
\alias{EN_HistData}
\title{Retrieve Historical Stock Data from Euronext}
\usage{
EN_HistData(
  ticker,
  from = Sys.Date() - 91,
  to = Sys.Date() - 1,
  stock_type = "Eq_Ind",
  escape = FALSE
)
}
\arguments{
\item{ticker}{A character string representing the company's ticker, name, or ISIN.}

\item{from}{The start date for historical data (default: 91 days ago). Only dates not exceeding 2 years ago are allowed for the 'from' parameter.}

\item{to}{The end date for historical data (default: yesterday).}

\item{stock_type}{The type of the ticker: 'Eq_Ind' for Stocks and Indexes, 'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers, and 'Etfs' or "E" for EFTs.}

\item{escape}{Boolean, either TRUE or FALSE. If escape is True, it means you're providing the DNA (ISIN-Market identifier) directly. Giving T to escape is helpful to avoid time-consuming operations; otherwise, F means you need to provide the Ticker symbol, name, or ISIN and the type of market to which it belongs.}
}
\value{
A data frame containing historical stock data, including columns for Date,
Open, High, Low, Last, Close, 'Number of shares', Turnover, and VWAP.
}
\description{
This function fetches historical stock data from Euronext based on the given
ticker symbol. You can specify a date range using the 'from' and 'to'
parameters. Additionally, provide the type of the ticker as 'Eq_Ind' for Stocks and Indexes,
'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers,
and 'Etfs' or "E" for EFTs.
}
\examples{

library(httr)
library(jsonlite)
library(rvest)
library(stringr)
library(magrittr)
library(rlang)

#To get historical data of Bond issued by IT0005386716-XMOT
hc_RMBS <- EN_HistData("XS1548458014-XAMS", escape = TRUE, from = "2022-10-30",stock_type = "B")
head(hc_RMBS)

\donttest{

# Fetch historical data for ABCA from October 30, 2023, to January 27, 2024
hc_abca <- EN_HistData("ABCA", from = "2023-10-30", to = "2024-01-27")
head(hc_abca)

# Fetch historical data for ETF AAPL from December 15, 2023, to now
hc_aapl <- EN_HistData("AAPL", stock_type = "E", from = "2023-12-15", to = Sys.Date())
head(hc_aapl)


# Fetch historical data for ABCA with the default date range
hc_ABCA <-  EN_HistData("ABCA")
head(hc_ABCA)

# To Get KGHDF's Fund data
hc_KGHDF <- EN_HistData("KGHDF", stock_type = "F", from = "2022-10-30")
head(hc_KGHDF)

EN_HistData("ABCAhh") # Will return "Ticker not found"
}

}
\seealso{
\code{\link{EN_GetISIN}} to retrieve the ISIN for a given ticker.

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_OrderBook.Chart}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_Performance}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\concept{Data Retrieval}
\concept{Euronext}
