% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambiental.R
\name{plast}
\alias{plast}
\title{Soybean plastochron estimation}
\usage{
plast(GEN, AAT, STAD, NN, habit = "ind", verbose = FALSE, plot = FALSE)
}
\arguments{
\item{GEN}{The column with the genotype name.}

\item{AAT}{The column with the average air temperature values.}

\item{STAD}{The column with the phenological stages of soybean, as described by
Fehr & Caviness (1977).}

\item{NN}{The column with the number of nodes measured in field.}

\item{habit}{Growth habit of the genotype (default = "ind"). Use "ind" for
indeterminate and "det" for determinate.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}

\item{plot}{Logical argument. Returns a graph with the linear models if TRUE.}
}
\value{
If the growth habit is determined, the function returns a linear model
for the V1 to R1 stages (Early Pheno) and a linear model for the R1 to R5
stages (Late Pheno). If the growth habit is indeterminate, returns three linear
models: Early Pheno (V1 to R1), Intermediate Pheno (R1 to R3) and Late Pheno
(R3 to R5).
}
\description{
Estimation of soybean plastochron using average air temperature and number of
nodes
}
\examples{
library(EstimateBreed)
data("pheno")

mod1 <- with(pheno, plast(GEN,TMED,EST,NN,habit="ind",plot=TRUE))
mod1
}
\references{
Porta, F. S. D., Streck, N. A., Alberto, C. M., da Silva, M. R.,
& Tura, E. F. (2024). Improving understanding of the plastochron of
determinate and indeterminate soybean cultivars. Revista Brasileira de
Engenharia Agricola e Ambiental, 28(10), e278299.
\doi{10.1590/1807-1929/agriambi.v28n10e278299}

Fehr, W. R., & Caviness, C. E. (1977). Stages of soybean development.
Iowa State University of Science and Technology Special Report, 80, 1-11.
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
