% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSGrouped.R
\name{plotTSGrouped}
\alias{plotTSGrouped}
\title{Multiple time series plot}
\usage{
plotTSGrouped(
  .data,
  xvar = "",
  xlabel = "",
  yvar = "",
  ylabel = "",
  group = "",
  fill_color = EcdcColors(col_scale = "qual", n = length(unique(.data[[group]]))),
  log10_scale = FALSE,
  xvar_format = "\%Y",
  xvar_breaks = "1 year"
)
}
\arguments{
\item{.data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the time variable (expects date format)
to plot on the x-axis in quotes}

\item{xlabel}{character string, label of the x axis}

\item{yvar}{character string, name of the numerical variable to plot on the y-axis in quotes}

\item{ylabel}{character string, label of the y axis}

\item{group}{character string, name of the grouping variable in quotes, e.g. gender.}

\item{fill_color}{character string, hexadecimal colour to use in the graph;
(default to ECDC green \code{"#65B32E"},
see \code{EcdcColors(col_scale = "qual", n = length(unique(.data[[group]])))}}

\item{log10_scale}{boolean, \code{TRUE} if y-axis should be log scale
(default \code{FALSE} ,see \code{ggplot2::scale_y_log10})}

\item{xvar_format}{character string, time format to use to plot the x-axis
(\code{"\%Y"} for yearly labels or \code{"\%b \%Y"} for monthly labels)}

\item{xvar_breaks}{character string, time unit to use to plot the x-axis between breaks
(\code{"1 year"} or \code{"1 month"}, see \code{ggplot2::scale_x_date(date_breaks = ... )})}
}
\description{
This function draws a time series of the values of variable 'Yvar'
with the time variable 'Xvar' on the x-axis.
The categorical variable that specify the group of the observations
for which there will be one time series each. \cr
Expects aggregated data.
}
\examples{
# --- Create dummy data
mydat <- data.frame(TimeCode = seq(as.Date("2008/1/1"), as.Date("2017/1/1"), "years"),
                    YValue = sample(1:79/10, 20),
                    YLabel = rep(c("Acute", "Chronic"), each = 10))

# --- Plot the dummy data
plotTSGrouped(mydat,
              xvar = "TimeCode",
              xlabel = "Year",
              yvar = "YValue",
              ylabel = "Rate per 100 000 population",
              group = "YLabel",
              log10_scale = TRUE,
              xvar_format = "\%Y",
              xvar_breaks = "1 year")

# --- Create dummy data
mydat <- data.frame(TimeCode = rep(seq(as.Date("2008/1/1"), as.Date("2017/1/1"), "years"), 5),
                    YValue = c(sample(1:50/10, 10),
                               sample(1:100/10, 10),
                               sample(1:300/10, 10),
                               sample(1:400/10, 10),
                               sample(1:500/10, 10)),
                    YLabel = rep(c("United Kingdom",
                                   "France",
                                   "Spain",
                                   "Netherlands",
                                   "Belgium"), each = 10))

# --- Plot the dummy data
plotTSGrouped(mydat,
              xvar = "TimeCode",
              xlabel = "Year",
              yvar = "YValue",
              ylabel = "Rate per 100 000 population",
              group = "YLabel",
              log10_scale = FALSE,
              xvar_format = "\%Y",
              xvar_breaks = "1 year")

}
\seealso{
Internal function: \code{\link{EcdcColors}} \cr
Required Packages: \code{\link[ggplot2]{ggplot}}
}
\keyword{timeseries}
